/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.messaging;

import ch.admin.bit.jeap.command.avro.AvroCommandBuilder;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommand;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandPayload;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandReferences;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandResourceReference;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandType;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.messaging.model.MessageReferences;
import java.time.LocalDateTime;

public class NotifyClientCommandBuilder
extends AvroCommandBuilder<NotifyClientCommandBuilder, NotifyClientCommand> {
    private final String serviceName;
    private final String systemName;
    private String resourcePath;
    private NotifyClientCommandType type;

    public static NotifyClientCommand buildCommand(String systemName, String serviceName, String resourcePath, NotifyClientCommandType type, String processId) {
        NotifyClientCommandBuilder builder = new NotifyClientCommandBuilder(serviceName, systemName);
        builder.setResourcePath(resourcePath);
        builder.setType(type);
        builder.setProcessId(processId);
        return builder.build();
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setType(NotifyClientCommandType type) {
        this.type = type;
    }

    private NotifyClientCommandBuilder(String serviceName, String systemName) {
        super(NotifyClientCommand::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public NotifyClientCommand build() {
        this.idempotenceId(this.createIdempotenceId());
        NotifyClientCommandPayload payload = NotifyClientCommandPayload.newBuilder().setType(this.type).build();
        this.setPayload((MessagePayload)payload);
        NotifyClientCommandReferences references = NotifyClientCommandReferences.newBuilder().setResourceReference(NotifyClientCommandResourceReference.newBuilder().setResourcePath(this.resourcePath).build()).build();
        this.setReferences((MessageReferences)references);
        return (NotifyClientCommand)super.build();
    }

    private String createIdempotenceId() {
        return String.format("%s-%s-%s-%s-%s", this.systemName, this.serviceName, this.resourcePath, this.type.name(), LocalDateTime.now());
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected NotifyClientCommandBuilder self() {
        return this;
    }
}

