/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.messaging;

import ch.admin.bit.jeap.command.notify.client.NotifyClientCommand;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandType;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.server.sent.events.domain.ResourceMutationListener;
import ch.admin.bit.jeap.server.sent.events.domain.ResourceMutationType;
import ch.admin.bit.jeap.server.sent.events.messaging.NotifyClientCommandBuilder;
import ch.admin.bit.jeap.server.sent.events.messaging.NotifyClientKafkaException;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.StringUtils;

public class NotifyClientCommandProducer
implements ResourceMutationListener {
    private final String topic;
    private final KafkaProperties kafkaProperties;
    private final KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate;

    @PostConstruct
    public void init() {
        if (!StringUtils.hasText((String)this.kafkaProperties.getSystemName())) {
            throw new IllegalArgumentException("System name is required");
        }
    }

    public void onResourceMutation(String applicationName, ResourceMutationType type, String resourcePath, String processId) {
        NotifyClientCommand command = NotifyClientCommandBuilder.buildCommand(this.kafkaProperties.getSystemName(), applicationName, resourcePath, this.convertToCommandType(type), processId);
        this.sendSync(this.topic, null, (AvroMessage)command);
    }

    private NotifyClientCommandType convertToCommandType(ResourceMutationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ResourceMutationType.RESOURCE_CREATED -> NotifyClientCommandType.RESOURCE_CREATED;
            case ResourceMutationType.RESOURCE_UPDATED -> NotifyClientCommandType.RESOURCE_UPDATED;
            case ResourceMutationType.RESOURCE_DELETED -> NotifyClientCommandType.RESOURCE_DELETED;
        };
    }

    private void sendSync(String topic, AvroMessageKey key, AvroMessage message) {
        try {
            this.kafkaTemplate.send(topic, (Object)key, (Object)message).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw NotifyClientKafkaException.producingCommandFailed(e);
        }
        catch (ExecutionException e) {
            throw NotifyClientKafkaException.producingCommandFailed(e);
        }
    }

    @Generated
    public NotifyClientCommandProducer(String topic, KafkaProperties kafkaProperties, KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate) {
        this.topic = topic;
        this.kafkaProperties = kafkaProperties;
        this.kafkaTemplate = kafkaTemplate;
    }
}

