/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.web;

import ch.admin.bit.jeap.security.resource.authentication.ServletSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NotifyClientAuthorizationConfigurationValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyClientAuthorizationConfigurationValidator.class);
    private final boolean insecureEnabled;
    private final Optional<ServletSemanticAuthorization> jeapSemanticAuthorization;
    private final String resource;
    private final String operation;
    private final Optional<ServletSimpleAuthorization> simpleAuthorization;
    private final String role;

    @PostConstruct
    public void validate() {
        if (this.insecureEnabled && (StringUtils.hasText((String)this.resource) || StringUtils.hasText((String)this.operation) || StringUtils.hasText((String)this.role))) {
            log.warn("If insecure permit is, resource, operation or role should not be specified.");
            throw new IllegalArgumentException("If insecure permit is, resource, operation or role should not be specified.");
        }
        if (!(this.insecureEnabled || StringUtils.hasText((String)this.resource) || StringUtils.hasText((String)this.operation) || StringUtils.hasText((String)this.role))) {
            log.warn("Either set insecure permit, or specify resource and operation or role for authorization.");
            throw new IllegalArgumentException("Either set insecure permit, or specify resource and operation or role for authorization.");
        }
        if (StringUtils.hasText((String)this.resource) && StringUtils.hasText((String)this.operation) && StringUtils.hasText((String)this.role)) {
            log.warn("Resource and operation are specified but role is also specified. This is not allowed for semantic or simple authorization, please specify both or neither.");
            throw new IllegalArgumentException("Resource and operation are specified but role is also specified. This is not allowed for semantic or simple authorization, please specify both or neither.");
        }
        if (StringUtils.hasText((String)this.resource) && !StringUtils.hasText((String)this.operation)) {
            log.warn("Resource is specified but operation is not. This is not allowed for semantic authorization, please specify both or neither.");
            throw new IllegalArgumentException("Resource is specified but operation is not.");
        }
        if (StringUtils.hasText((String)this.operation) && !StringUtils.hasText((String)this.resource)) {
            log.warn("Operation is specified but resource is not. This is not allowed for semantic authorization, please specify both or neither.");
            throw new IllegalArgumentException("Resource is specified but operation is not.");
        }
        if (StringUtils.hasText((String)this.resource) && StringUtils.hasText((String)this.operation) && !this.jeapSemanticAuthorization.isPresent()) {
            log.warn("Resource and operation are specified but jeapSemanticAuthorization is not.");
            throw new IllegalArgumentException("Resource and operation are specified but jeapSemanticAuthorization is not.");
        }
        if (StringUtils.hasText((String)this.role) && !this.simpleAuthorization.isPresent()) {
            log.warn("Role is specified but simpleAuthorization is not.");
            throw new IllegalArgumentException("Role is specified but simpleAuthorization is not.");
        }
    }

    @Generated
    public NotifyClientAuthorizationConfigurationValidator(boolean insecureEnabled, Optional<ServletSemanticAuthorization> jeapSemanticAuthorization, String resource, String operation, Optional<ServletSimpleAuthorization> simpleAuthorization, String role) {
        this.insecureEnabled = insecureEnabled;
        this.jeapSemanticAuthorization = jeapSemanticAuthorization;
        this.resource = resource;
        this.operation = operation;
        this.simpleAuthorization = simpleAuthorization;
        this.role = role;
    }
}

