/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.web;

import ch.admin.bit.jeap.server.sent.events.web.NotifyClientController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyClientHeartbeatSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyClientHeartbeatSender.class);
    private static final String HEARTBEAT_EVENT = "HEARTBEAT";
    private static final String HEARTBEAT_EVENT_DATA_TEMPLATE = "{ \"interval\": %s }";
    private final NotifyClientController notifyClientController;
    private final ScheduledExecutorService heartbeatScheduler;
    private final long rateInMs;

    public NotifyClientHeartbeatSender(NotifyClientController notifyClientController, long intervalInSeconds) {
        this(notifyClientController, Executors.newSingleThreadScheduledExecutor(), intervalInSeconds);
    }

    @PostConstruct
    public void init() {
        this.heartbeatScheduler.scheduleAtFixedRate(this::sendHeartbeats, this.rateInMs, this.rateInMs, TimeUnit.MILLISECONDS);
    }

    private void sendHeartbeats() {
        this.notifyClientController.sendEvent(HEARTBEAT_EVENT, HEARTBEAT_EVENT_DATA_TEMPLATE.formatted(this.rateInMs));
    }

    @PreDestroy
    public void shutdown() {
        log.info("Shutting down");
        this.heartbeatScheduler.shutdown();
    }

    @Generated
    public NotifyClientHeartbeatSender(NotifyClientController notifyClientController, ScheduledExecutorService heartbeatScheduler, long rateInMs) {
        this.notifyClientController = notifyClientController;
        this.heartbeatScheduler = heartbeatScheduler;
        this.rateInMs = rateInMs;
    }
}

