/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.web.spring;

import ch.admin.bit.jeap.security.resource.authentication.ServletSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClienAuthorization;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientAuthorizationConfigurationValidator;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientAuthorizationSemantic;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientAuthorizationSimple;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientController;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientHeartbeatSender;
import ch.admin.bit.jeap.server.sent.events.web.NotifyClientResourceMutationDataSender;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnProperty(name={"jeap.sse.enabled"}, havingValue="true", matchIfMissing=true)
@ComponentScan(basePackages={"ch.admin.bit.jeap.server.sent.events.web"})
public class ServerSentEventsWebAutoConfiguration {
    @Bean
    public NotifyClientResourceMutationDataSender notifyClientResourceMutationDataSender(NotifyClientController notifyClientController, ObjectMapper objectMapper) {
        return new NotifyClientResourceMutationDataSender(notifyClientController, objectMapper);
    }

    @Bean
    public NotifyClientHeartbeatSender notifyClientHeartbeatSender(@Value(value="${jeap.sse.web.heartbeat.rateInMs}") long rateInMs, NotifyClientController notifyClientController) {
        return new NotifyClientHeartbeatSender(notifyClientController, rateInMs);
    }

    @Bean
    public NotifyClienAuthorization notifyClientAuthorization(@Value(value="${jeap.sse.web.auth.resource:}") String resource, @Value(value="${jeap.sse.web.auth.operation:}") String operation, Optional<ServletSemanticAuthorization> semanticAuthorization, @Value(value="${jeap.sse.web.auth.role:}") String role, Optional<ServletSimpleAuthorization> simpleAuthorization) {
        if (StringUtils.hasText((String)resource) || StringUtils.hasText((String)operation)) {
            return new NotifyClientAuthorizationSemantic(resource, operation, semanticAuthorization.orElse(null));
        }
        if (StringUtils.hasText((String)role)) {
            return new NotifyClientAuthorizationSimple(role, simpleAuthorization.orElse(null));
        }
        return null;
    }

    @Bean
    public NotifyClientAuthorizationConfigurationValidator notifyClientControllerAuthenticationConfigurationValidator(@Value(value="${jeap.sse.web.insecure.enabled}") boolean insecureEnabled, Optional<ServletSemanticAuthorization> jeapSemanticAuthorization, @Value(value="${jeap.sse.web.auth.resource:}") String resource, @Value(value="${jeap.sse.web.auth.operation:}") String operation, Optional<ServletSimpleAuthorization> simpleAuthorization, @Value(value="${jeap.sse.web.auth.role:}") String role) {
        return new NotifyClientAuthorizationConfigurationValidator(insecureEnabled, jeapSemanticAuthorization, resource, operation, simpleAuthorization, role);
    }
}

