/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.web;

import ch.admin.bit.jeap.server.sent.events.web.NotifyClienAuthorization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@ConditionalOnProperty(name={"jeap.sse.enabled"}, havingValue="true", matchIfMissing=true)
public class NotifyClientController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyClientController.class);
    private final List<SseEmitter> emitters = new CopyOnWriteArrayList<SseEmitter>();
    private final long emitterTimeoutInMs;
    private final Optional<NotifyClienAuthorization> authorization;

    public NotifyClientController(@Value(value="${jeap.sse.web.emitter.timeoutInMs}") long emitterTimeoutInMs, Optional<NotifyClienAuthorization> authorization) {
        this.emitterTimeoutInMs = emitterTimeoutInMs;
        this.authorization = authorization;
    }

    @GetMapping(value={"${jeap.sse.web.endpoint}"}, produces={"text/event-stream"})
    public SseEmitter streamEvents() {
        this.authorization.ifPresent(NotifyClienAuthorization::check);
        log.trace("creating new SseEmitter");
        SseEmitter emitter = this.createEmitter(this.emitterTimeoutInMs);
        this.emitters.add(emitter);
        emitter.onCompletion(() -> this.emitters.remove(emitter));
        emitter.onTimeout(() -> this.emitters.remove(emitter));
        emitter.onError(ex -> this.emitters.remove(emitter));
        return emitter;
    }

    void sendEvent(String name, String data) {
        log.trace("Sending event '{}' with data '{}'", (Object)name, (Object)data);
        for (ResponseBodyEmitter responseBodyEmitter : new ArrayList<SseEmitter>(this.emitters)) {
            try {
                responseBodyEmitter.send(SseEmitter.event().name(name).data((Object)data).id(UUID.randomUUID().toString()).build());
            }
            catch (IOException e) {
                log.warn("Exception while sending to client, removing emitter", (Throwable)e);
                responseBodyEmitter.complete();
                this.emitters.remove(responseBodyEmitter);
            }
        }
    }

    SseEmitter createEmitter(long emitterTimeout) {
        return new SseEmitter(Long.valueOf(emitterTimeout));
    }
}

