/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import ch.admin.bit.jeap.config.client.AbstractClientConfigEnvPostProcessor;
import java.util.Map;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Order
public class ClientDefaultConfigEnvPostProcessor
extends AbstractClientConfigEnvPostProcessor {
    public static String CLIENT_DEFAULT_CONFIG_PROPERTY_SOURCE_NAME = "client-config-enabled-default";
    public static final Map<String, Object> ENABLED_DEFAULT_PROPERTIES = Map.of("spring.cloud.config.uri", "${vcap.services.config.credentials.uri}", "spring.cloud.config.username", "${vcap.services.config.credentials.username}", "spring.cloud.config.password", "${vcap.services.config.credentials.password}");

    protected ClientDefaultConfigEnvPostProcessor(DeferredLogFactory logFactory) {
        super(logFactory);
    }

    @Override
    protected void doPostProcessEnvironment(ConfigurableEnvironment environment, boolean configClientEnabled) {
        if (configClientEnabled) {
            this.log.info((Object)"Config client is enabled -> adding missing config client default properties.");
            this.addMissingPropertiesAsPropertySource(environment, ENABLED_DEFAULT_PROPERTIES, CLIENT_DEFAULT_CONFIG_PROPERTY_SOURCE_NAME);
        } else {
            this.log.info((Object)"Config client is disabled -> not adding default properties.");
        }
    }
}

