/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

abstract class AbstractClientConfigEnvPostProcessor
implements EnvironmentPostProcessor {
    protected Log log;

    protected AbstractClientConfigEnvPostProcessor(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean configClientEnabled = Boolean.parseBoolean(environment.getProperty("jeap.config.client.enabled", "true"));
        this.doPostProcessEnvironment(environment, configClientEnabled);
    }

    protected abstract void doPostProcessEnvironment(ConfigurableEnvironment var1, boolean var2);

    protected void addMissingPropertiesAsPropertySource(ConfigurableEnvironment environment, Map<String, Object> properties, String name) {
        HashMap<String, Object> missingDefaults = new HashMap<String, Object>(properties);
        properties.keySet().stream().filter(arg_0 -> ((ConfigurableEnvironment)environment).containsProperty(arg_0)).forEach(missingDefaults::remove);
        if (!missingDefaults.isEmpty()) {
            this.log.info((Object)"Adding missing config properties (%s) in config source %s.".formatted(String.join((CharSequence)", ", missingDefaults.keySet()), name));
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource(name, missingDefaults));
        } else {
            this.log.info((Object)"Not adding any config properties.");
        }
    }
}

