/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import ch.admin.bit.jeap.config.client.AbstractClientConfigEnvPostProcessor;
import java.util.Map;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Order(value=-2147483639)
public class ClientBaseConfigEnvPostProcessor
extends AbstractClientConfigEnvPostProcessor {
    public static final Map<String, Object> ENABLED_BASE_PROPERTIES = Map.of("spring.cloud.config.fail-fast", "${jeap.config.client.fail-fast:true}", "info.config.version", "${jeap.config.server.config.version}", "info.config.buildtime", "${jeap.config.server.config.version.buildtime}", "info.config.commitid", "${jeap.config.server.config.version.commitid}");
    public static final Map<String, Object> DISABLED_PROPERTIES = Map.of("spring.cloud.config.enabled", "false", "spring.cloud.bus.enabled", "false");

    protected ClientBaseConfigEnvPostProcessor(DeferredLogFactory logFactory) {
        super(logFactory);
    }

    @Override
    protected void doPostProcessEnvironment(ConfigurableEnvironment environment, boolean configClientEnabled) {
        if (configClientEnabled) {
            this.log.info((Object)"Config client is enabled -> adding missing config client base properties.");
            this.addMissingPropertiesAsPropertySource(environment, ENABLED_BASE_PROPERTIES, "client-config-enabled-base");
        } else {
            this.log.info((Object)"Config client is disabled -> adding config client disabled properties.");
            this.addMissingPropertiesAsPropertySource(environment, DISABLED_PROPERTIES, "client-config-disabled");
        }
    }
}

