/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import java.util.Arrays;
import java.util.HashMap;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.bootstrap.BootstrapApplicationListener;
import org.springframework.cloud.bootstrap.BootstrapConfigFileApplicationListener;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.refresh.LegacyContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class FixedLegacyContextRefresher
extends LegacyContextRefresher {
    public FixedLegacyContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshAutoConfiguration.RefreshProperties properties) {
        super(context, scope, properties);
    }

    protected void updateEnvironment() {
        this.fixedAddConfigFilesToEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurableApplicationContext fixedAddConfigFilesToEnvironment() {
        ConfigurableApplicationContext capture = null;
        try {
            StandardEnvironment environment = this.copyEnvironment(this.getContext().getEnvironment());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("spring.jmx.enabled", false);
            map.put("spring.main.sources", "");
            map.put("spring.main.web-application-type", "NONE");
            map.put("spring.cloud.bootstrap.enabled", Boolean.TRUE.toString());
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("refreshArgs", map));
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{ContextRefresher.Empty.class}).bannerMode(Banner.Mode.OFF).web(WebApplicationType.NONE).environment((ConfigurableEnvironment)environment);
            builder.application().setListeners(Arrays.asList(new BootstrapApplicationListener(), new BootstrapConfigFileApplicationListener()));
            capture = builder.run(new String[0]);
            if (environment.getPropertySources().contains("refreshArgs")) {
                environment.getPropertySources().remove("refreshArgs");
            }
            MutablePropertySources target = this.getContext().getEnvironment().getPropertySources();
            String targetName = null;
            for (PropertySource source : environment.getPropertySources()) {
                String name = source.getName();
                if (target.contains(name)) {
                    targetName = name;
                }
                if (this.standardSources.contains(name)) continue;
                if (target.contains(name)) {
                    target.replace(name, source);
                    continue;
                }
                if (targetName != null) {
                    target.addAfter(targetName, source);
                    targetName = name;
                    continue;
                }
                target.addFirst(source);
                targetName = name;
            }
            MutablePropertySources originPropertySources = environment.getPropertySources();
            for (PropertySource targetPropertySource : target) {
                String targetPropertySourceName = targetPropertySource.getName();
                if (!targetPropertySourceName.startsWith("bootstrapProperties-") || originPropertySources.contains(targetPropertySourceName)) continue;
                target.remove(targetPropertySourceName);
            }
        }
        finally {
            for (ConfigurableApplicationContext closeable = capture; closeable != null; closeable = (ConfigurableApplicationContext)closeable.getParent()) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
                if (!(closeable.getParent() instanceof ConfigurableApplicationContext)) break;
            }
        }
        return capture;
    }
}

