/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import lombok.Generated;
import org.springframework.core.env.Environment;

abstract class JeapKafkaProperties {
    private String bootstrapServers;
    private String securityProtocol;
    private String username;
    private String password;

    JeapKafkaProperties() {
    }

    protected void initializeFrom(Environment environment) {
        this.bootstrapServers = environment.getProperty(this.getPrefix() + "bootstrap-servers");
        this.securityProtocol = environment.getProperty(this.getPrefix() + "security-protocol");
        this.username = environment.getProperty(this.getPrefix() + "username");
        this.password = environment.getProperty(this.getPrefix() + "password");
    }

    boolean isConfigured() {
        return this.bootstrapServers != null;
    }

    boolean isSsl() {
        if (this.securityProtocol == null) {
            return false;
        }
        return this.securityProtocol.endsWith("SSL");
    }

    boolean isSasl() {
        if (this.securityProtocol == null) {
            return false;
        }
        return this.securityProtocol.startsWith("SASL");
    }

    protected abstract String getPrefix();

    @Generated
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Generated
    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }
}

