/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.config.client;

import ch.admin.bit.jeap.config.client.JeapCloudBusKafkaProperties;
import ch.admin.bit.jeap.config.client.JeapKafkaProperties;
import ch.admin.bit.jeap.config.client.JeapMessagingKafkaProperties;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class CloudBusKafkaConfigEnvPostProcessor
implements EnvironmentPostProcessor {
    private static final String SASL_MECHANISM = "SCRAM-SHA-512";
    private static final String SASL_JAAS_TEMPLATE = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"%s\" password=\"%s\";";
    private static final String CLOUD_BUS_PROPERTY_SOURCE_NAME = "cloudBusProperties";
    private static final String CLOUD_BUS_KAFKA_BROKERS_KEY = "spring.cloud.stream.kafka.binder.brokers";
    private final Log log;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.log.debug((Object)"CloudBusKafkaConfigEnvPostProcessor starts configuring cloud bus kafka connection.");
        HashMap<String, Object> cloudBusKafkaProps = new HashMap<String, Object>();
        this.configureCommonCloudBusKafkaProperties(cloudBusKafkaProps);
        JeapCloudBusKafkaProperties jeapCloudBusKafkaProps = JeapCloudBusKafkaProperties.from((Environment)environment);
        JeapMessagingKafkaProperties jeapMessagingKafkaProps = JeapMessagingKafkaProperties.from((Environment)environment);
        if (jeapCloudBusKafkaProps.isConfigured()) {
            this.log.debug((Object)"Found a jEAP cloud bus config -> configuring cloud bus based on those settings.");
            this.configureCloudBusKafkaProperties(cloudBusKafkaProps, jeapCloudBusKafkaProps, (Environment)environment);
        } else if (jeapMessagingKafkaProps.isConfigured()) {
            this.log.debug((Object)"No jEAP cloud bus config found, but there is a jEAP messaging config -> configuring cloud bus based on the jEAP messaging settings.");
            this.configureCloudBusKafkaProperties(cloudBusKafkaProps, jeapMessagingKafkaProps, (Environment)environment);
        } else {
            this.log.debug((Object)"No jEAP cloud bus config and no jEAP messaging config found -> won't configure cloud bus.");
            cloudBusKafkaProps.clear();
        }
        environment.getPropertySources().addLast(this.createCloudBusPropertySource(cloudBusKafkaProps));
        this.log.debug((Object)"CloudBusKafkaConfigEnvPostProcessor finished configuring cloud bus kafka connection.");
    }

    private void configureCommonCloudBusKafkaProperties(Map<String, Object> targetProps) {
        targetProps.put("spring.cloud.stream.kafka.binder.auto-create-topics", "false");
    }

    private PropertySource<?> createCloudBusPropertySource(Map<String, Object> props) {
        return new MapPropertySource(CLOUD_BUS_PROPERTY_SOURCE_NAME, props);
    }

    private void configureCloudBusKafkaProperties(Map<String, Object> targetProps, JeapCloudBusKafkaProperties jeapCloudBusKafkaProperties, Environment environment) {
        String jeapCloudBusBrokers = jeapCloudBusKafkaProperties.getBootstrapServers();
        this.log.info((Object)("Configuring cloud bus kafka connection with brokers given by the jEAP cloud bus config (" + jeapCloudBusBrokers + ")."));
        targetProps.put(CLOUD_BUS_KAFKA_BROKERS_KEY, jeapCloudBusBrokers);
        this.addSecurityConfig(targetProps, jeapCloudBusKafkaProperties, environment);
    }

    private void configureCloudBusKafkaProperties(Map<String, Object> targetProps, JeapMessagingKafkaProperties jeapMessagingKafkaProperties, Environment environment) {
        if (jeapMessagingKafkaProperties.getConsumerBootstrapServers() != null) {
            String jeapMessagingConsumerBrokers = jeapMessagingKafkaProperties.getConsumerBootstrapServers();
            this.log.info((Object)("Configuring cloud bus kafka connection with consumer brokers from jEAP messaging (" + jeapMessagingConsumerBrokers + ")."));
            targetProps.put(CLOUD_BUS_KAFKA_BROKERS_KEY, jeapMessagingConsumerBrokers);
        } else {
            String jeapMessagingBrokers = jeapMessagingKafkaProperties.getBootstrapServers();
            this.log.info((Object)("Configuring cloud bus kafka connection with brokers from jEAP messaging (" + jeapMessagingBrokers + ")."));
            targetProps.put(CLOUD_BUS_KAFKA_BROKERS_KEY, jeapMessagingBrokers);
        }
        this.addSecurityConfig(targetProps, jeapMessagingKafkaProperties, environment);
    }

    private void addSecurityConfig(Map<String, Object> targetProps, JeapKafkaProperties config, Environment environment) {
        targetProps.put("spring.cloud.stream.kafka.binder.configuration.security.protocol", config.getSecurityProtocol());
        if (config.isSasl()) {
            this.log.debug((Object)"Configuring cloud bus kafka connection with SASL (SCRAM-SHA-512).");
            targetProps.put("spring.cloud.stream.kafka.binder.configuration.sasl.mechanism", SASL_MECHANISM);
            String saslJaasConfig = String.format(SASL_JAAS_TEMPLATE, config.getUsername(), config.getPassword());
            targetProps.put("spring.cloud.stream.kafka.binder.configuration.sasl.jaas.config", saslJaasConfig);
        }
        if (config.isSsl()) {
            String truststoreLocation = environment.getProperty("javax.net.ssl.trustStore");
            this.log.debug((Object)("Configuring cloud bus kafka connection with SSL (truststore: " + truststoreLocation + ")."));
            targetProps.put("spring.cloud.stream.kafka.binder.configuration.ssl.truststore.location", truststoreLocation);
            targetProps.put("spring.cloud.stream.kafka.binder.configuration.ssl.truststore.password", environment.getProperty("javax.net.ssl.trustStorePassword"));
        }
    }

    @Generated
    public CloudBusKafkaConfigEnvPostProcessor(Log log) {
        this.log = log;
    }
}

