/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.metrics;

import ch.admin.bit.jeap.log.metrics.LoggingMetricsProvider;
import ch.admin.bit.jeap.log.metrics.MicrometerLoggingMetricsProvider;
import ch.admin.bit.jeap.log.metrics.NopLoggingMetricsProvider;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;

public class LoggingMetrics
implements DisposableBean {
    static LoggingMetricsProvider staticLoggingMetricsProvider = null;
    private static final AtomicInteger distributedLogConnectionEstablished = new AtomicInteger(0);
    private static final AtomicInteger distributedLogConnectionError = new AtomicInteger(0);
    private static final AtomicInteger distributedLogTransmitError = new AtomicInteger(0);

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        try {
            Class<?> meterRegistryType = Class.forName("io.micrometer.core.instrument.MeterRegistry");
            Object meterRegistry = event.getApplicationContext().getBean(meterRegistryType);
            staticLoggingMetricsProvider = new MicrometerLoggingMetricsProvider(meterRegistry);
            this.flushCounters();
        }
        catch (Throwable t) {
            staticLoggingMetricsProvider = new NopLoggingMetricsProvider();
        }
    }

    private synchronized void flushCounters() {
        LoggingMetrics.flushCounter(distributedLogConnectionEstablished, LoggingMetrics::incrementDistributedLogConnectionEstablished);
        LoggingMetrics.flushCounter(distributedLogConnectionError, LoggingMetrics::incrementDistributedLogConnectionError);
        LoggingMetrics.flushCounter(distributedLogTransmitError, LoggingMetrics::incrementDistributedLogTransmitError);
    }

    private static void flushCounter(AtomicInteger counter, Runnable action) {
        for (int i = 0; i < counter.getAndSet(0); ++i) {
            action.run();
        }
    }

    public void destroy() {
        staticLoggingMetricsProvider = null;
    }

    public static void incrementDistributedLogConnectionEstablished() {
        LoggingMetrics.withMetricsProviderOrFallback(LoggingMetricsProvider::incrementDistributedLogConnectionEstablished, distributedLogConnectionEstablished);
    }

    public static void incrementDistributedLogConnectionError() {
        LoggingMetrics.withMetricsProviderOrFallback(LoggingMetricsProvider::incrementDistributedLogConnectionError, distributedLogConnectionError);
    }

    public static void incrementDistributedLogTransmitError() {
        LoggingMetrics.withMetricsProviderOrFallback(LoggingMetricsProvider::incrementDistributedLogTransmitError, distributedLogTransmitError);
    }

    public static void distributedLogTransmitTime(Duration duration) {
        LoggingMetricsProvider metricsProvider = staticLoggingMetricsProvider;
        if (metricsProvider != null) {
            metricsProvider.distributedLogTransmitTime(duration);
        }
    }

    private static void withMetricsProviderOrFallback(Consumer<LoggingMetricsProvider> withMetricsProvider, AtomicInteger fallback) {
        LoggingMetricsProvider metricsProvider = staticLoggingMetricsProvider;
        if (metricsProvider != null) {
            withMetricsProvider.accept(metricsProvider);
        } else {
            fallback.getAndIncrement();
        }
    }
}

