/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.rest;

import ch.admin.bit.jeap.rest.tracing.RestRequestListener;
import ch.admin.bit.jeap.rest.tracing.RestRequestTrace;
import ch.admin.bit.jeap.rest.tracing.RestResponseListener;
import ch.admin.bit.jeap.rest.tracing.RestResponseTrace;
import ch.admin.bit.jeap.rest.tracing.TracerConfiguration;
import java.util.regex.Pattern;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestLogger
implements RestRequestListener,
RestResponseListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ch.admin.bit.jeap.log.RestRequestTracer");
    private static final String REDUCED_MESSAGE_FORMAT_FOR_JSON_LOGS = "{} {} {} {} {}";
    private final Pattern filterPattern;
    private final boolean fullResponseDetailsInMessage;

    public RestRequestLogger(TracerConfiguration tracerConfiguration) {
        this.filterPattern = tracerConfiguration.getUriFilterPattern();
        this.fullResponseDetailsInMessage = tracerConfiguration.isFullResponseDetailsInMessage();
    }

    public void onRequest(RestRequestTrace restRequestTrace) {
        String uri = restRequestTrace.getRequestUri();
        if (this.isRequestListenerActive() && this.shouldLogUri(uri)) {
            log.trace("Incoming {} {} Request to {}", new Object[]{restRequestTrace.getProtocol(), StructuredArguments.value((String)"method", (Object)restRequestTrace.getMethod()), StructuredArguments.value((String)"uri", (Object)uri)});
        }
    }

    public void onResponse(RestResponseTrace restResponseTrace) {
        String uri = restResponseTrace.getRequestUri();
        if (this.isResponseListenerActive() && this.shouldLogUri(uri)) {
            String format = this.fullResponseDetailsInMessage ? "{} {} {} {} {} {} {} {} {} {}" : REDUCED_MESSAGE_FORMAT_FOR_JSON_LOGS;
            log.debug(format, new Object[]{StructuredArguments.value((String)"method", (Object)restResponseTrace.getMethod()), StructuredArguments.value((String)"uri", (Object)uri), StructuredArguments.keyValue((String)"result", (Object)restResponseTrace.getStatusCode()), StructuredArguments.keyValue((String)"caller", (Object)restResponseTrace.getCaller()), StructuredArguments.keyValue((String)"user", (Object)restResponseTrace.getUser()), StructuredArguments.keyValue((String)"dt", (Object)restResponseTrace.getElapsedMs()), StructuredArguments.keyValue((String)"remoteAddr", (Object)restResponseTrace.getRemoteAddr()), StructuredArguments.keyValue((String)"requestHeaders", (Object)restResponseTrace.getRequestHeaders()), StructuredArguments.keyValue((String)"responseHeaders", (Object)restResponseTrace.getResponseHeaders()), StructuredArguments.keyValue((String)"attributes", (Object)restResponseTrace.getAttributes())});
        }
    }

    private boolean shouldLogUri(String uri) {
        if (this.filterPattern == null) {
            return true;
        }
        return !this.filterPattern.matcher(uri).matches();
    }

    public boolean isRequestListenerActive() {
        return log.isTraceEnabled();
    }

    public boolean isResponseListenerActive() {
        return log.isDebugEnabled();
    }
}

