/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.syslog.connection;

import ch.admin.bit.jeap.log.metrics.LoggingMetrics;
import ch.admin.bit.jeap.log.syslog.connection.ConnectionState;
import ch.admin.bit.jeap.log.syslog.connection.TLSSyslogConnectionProperties;
import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.net.ssl.SSLConfigurableSocket;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import jdk.net.ExtendedSocketOptions;
import lombok.Generated;

public class TLSSyslogConnection {
    private final SSLContext sslContext;
    private final SSLParametersConfiguration sslParameters;
    private final TLSSyslogConnectionProperties props;
    private final ConnectionState connectionState = ConnectionState.disconnected();
    private boolean connectionLoggedOnce = false;
    private SSLSocket clientSocket;
    private String lastTransmitError;

    public static TLSSyslogConnection create(ContextAware context, TLSSyslogConnectionProperties props) throws GeneralSecurityException {
        SSLContext sslContext = props.getSsl().createContext(context);
        SSLParametersConfiguration parameters = props.getSsl().getParameters();
        parameters.setContext(context.getContext());
        return new TLSSyslogConnection(sslContext, parameters, props);
    }

    public void transmit(byte[] syslogMessage) {
        boolean success;
        if (this.connectionState.shouldReconnect()) {
            this.attemptConnection();
        }
        if (!this.connectionState.isConnected()) {
            this.debug("not transmitting - not connected");
        }
        if (!(success = this.attemptTransmit(syslogMessage))) {
            this.debug("transmit failed - retrying");
            this.disconnect();
            this.attemptConnection();
            success = this.attemptTransmit(syslogMessage);
            if (!success) {
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptTransmit(byte[] syslogMessage) {
        this.debug("attempt transmit");
        long start = System.nanoTime();
        try {
            OutputStream outputStream = this.clientSocket.getOutputStream();
            outputStream.write(syslogMessage);
            outputStream.flush();
            this.debug("transmit successful");
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            this.debug("transmit failed", ex.getMessage());
            this.lastTransmitError = ex.getMessage();
            LoggingMetrics.incrementDistributedLogTransmitError();
            boolean bl = false;
            return bl;
        }
        finally {
            LoggingMetrics.distributedLogTransmitTime(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    public boolean attemptConnection() {
        long start = System.currentTimeMillis();
        try {
            SSLSocket sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket();
            sslSocket.setUseClientMode(true);
            sslSocket.setSoTimeout(this.props.getTimeoutMillis());
            this.sslParameters.configure((SSLConfigurable)new SSLConfigurableSocket(sslSocket));
            sslSocket.connect(new InetSocketAddress(this.props.getSyslogHost(), (int)this.props.getPort()), this.props.getTimeoutMillis());
            sslSocket.setTcpNoDelay(true);
            sslSocket.setKeepAlive(true);
            sslSocket.setOption(ExtendedSocketOptions.TCP_KEEPIDLE, this.props.getTcpKeepIdleSeconds());
            sslSocket.setOption(ExtendedSocketOptions.TCP_KEEPCOUNT, 2);
            sslSocket.setOption(ExtendedSocketOptions.TCP_KEEPINTERVAL, 5);
            sslSocket.startHandshake();
            this.clientSocket = sslSocket;
            this.onConnectionSuccesful(System.currentTimeMillis() - start);
            return true;
        }
        catch (Exception ex) {
            this.disconnect();
            this.onConnectionError(ex);
            return false;
        }
    }

    public void disconnect() {
        this.debug("disconnect");
        this.connectionState.notifyDisconnected();
        CloseUtil.closeQuietly((Socket)this.clientSocket);
        this.clientSocket = null;
    }

    private void onConnectionSuccesful(long connectionElapsedTimeMs) {
        this.connectionState.notifyConnected();
        LoggingMetrics.incrementDistributedLogConnectionEstablished();
        if (!this.connectionLoggedOnce) {
            this.connectionLoggedOnce = true;
            System.out.printf("TLS Syslog Appender connected to %s:%d in %dms%n", this.props.getSyslogHost(), this.props.getPort(), connectionElapsedTimeMs);
        }
    }

    private void onConnectionError(Exception ex) {
        this.debug("connection not succesful", ex.getMessage());
        LoggingMetrics.incrementDistributedLogConnectionError();
        if (!this.connectionLoggedOnce) {
            this.connectionLoggedOnce = true;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8));
            System.out.printf("TLS Syslog Appender failed to connect to %s:%d: %s%n", this.props.getSyslogHost(), this.props.getPort(), baos.toString(StandardCharsets.UTF_8));
        }
    }

    private void debug(String msg) {
        this.debug(msg, null);
    }

    private void debug(String msg, Object details) {
        if (this.props.isDebugMode()) {
            System.err.println("[syslog] " + msg + (String)(details == null ? "" : " " + String.valueOf(details)));
        }
    }

    @Generated
    public TLSSyslogConnection(SSLContext sslContext, SSLParametersConfiguration sslParameters, TLSSyslogConnectionProperties props) {
        this.sslContext = sslContext;
        this.sslParameters = sslParameters;
        this.props = props;
    }

    @Generated
    public String getLastTransmitError() {
        return this.lastTransmitError;
    }
}

