/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.logback;

import ch.admin.bit.jeap.log.logback.AbstractContextListenerBase;

public class JeapLogConfigurationContextListener
extends AbstractContextListenerBase {
    static final String JEAP_LOGGING_PLATFORM = "jeapLoggingPlatform";
    static final String CLOUDWATCH_PLATFORM_VALUE = "cloudwatch";
    static final String RHOS_PLATFORM_VALUE = "rhos";
    static final String LOGRELAY_PROFILE = "logrelayProfile";
    static final String CLOUD_PROFILE = "cloudProfile";
    static final String ROLLING_LOG_FILE_PROFILE = "rollingLogFileProfile";
    static final String ADMIN_ENABLED = "adminEnabled";
    static final String ADMIN_URL = "adminUrl";
    static final String TRUE = "true";
    static final String CLOUDWATCH_APPENDER = "cloudwatch";
    static final String RHOS_APPENDER = "rhos";
    static final String LOGRELAY_APPENDER = "logrelay";
    static final String CONSOLEJSON_APPENDER = "consolejson";
    static final String CONSOLETEXT_APPENDER = "consoletext";
    static final String ROLLINGFILE_APPENDER = "rollingfile";

    public void start() {
        if (this.isCloudwatch()) {
            this.context.putProperty("cloudwatch", TRUE);
        } else if (this.isRhos()) {
            this.context.putProperty("rhos", TRUE);
        } else if (this.isLogrelay()) {
            this.context.putProperty(LOGRELAY_APPENDER, TRUE);
        } else if (this.isCloud()) {
            this.context.putProperty(CONSOLEJSON_APPENDER, TRUE);
        } else {
            this.context.putProperty(CONSOLETEXT_APPENDER, TRUE);
        }
        if (this.isTrue(ADMIN_ENABLED) || this.hasAdminUrl() && !this.adminDisabled() || this.isTrue(ROLLING_LOG_FILE_PROFILE)) {
            this.context.putProperty(ROLLINGFILE_APPENDER, TRUE);
        }
    }

    private boolean isCloudwatch() {
        return this.isWantedPlatform("cloudwatch");
    }

    private boolean isRhos() {
        return this.isWantedPlatform("rhos");
    }

    private boolean isCloud() {
        return this.isTrue(CLOUD_PROFILE);
    }

    private boolean adminDisabled() {
        String value = this.context.getProperty(ADMIN_ENABLED);
        return "false".equalsIgnoreCase(value);
    }

    private boolean isLogrelay() {
        return this.isTrue(LOGRELAY_PROFILE);
    }

    private boolean hasAdminUrl() {
        String value = this.context.getProperty(ADMIN_URL);
        return value != null && !value.isBlank();
    }

    private boolean isTrue(String propertyName) {
        return Boolean.parseBoolean(this.context.getProperty(propertyName));
    }

    private boolean isWantedPlatform(String wantedPlatform) {
        String actualValue = this.context.getProperty(JEAP_LOGGING_PLATFORM);
        return wantedPlatform.equalsIgnoreCase(actualValue);
    }
}

