/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.cloudfoundry;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.JsonWritingUtils;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;

public class CloudFoundryAttributeProvider
extends AbstractJsonProvider<ILoggingEvent> {
    private static final String CF_APP_ID = "cf_app_id";
    private static final String CF_APP_NAME = "cf_app_name";
    private static final String CF_SPACE_ID = "cf_space_id";
    private static final String CF_SPACE_NAME = "cf_space_name";
    private static final String CF_ORG_ID = "cf_org_id";
    private static final String CF_ORG_NAME = "cf_org_name";
    private static final String CF_INSTANCE_ID = "cf_instance_id";
    private static final String CLUSTER_ENV = "cluster_env";
    private static final String CLUSTER_ENGINE = "cluster_engine";
    private static final String CLUSTER_ENGINE_VERSION = "cluster_engine_version";
    private static final String CLUSTER_NAME = "cluster_name";
    private static final String CLUSTER_NETWORK_ZONE = "cluster_network_zone";
    private static final String CLUSTER_DATACENTER = "cluster_datacenter";
    private static final String SOURCE_INSTANCE = "source_instance";
    private static final String SOURCE_TYPE = "source_type";
    private static final String APP_PROC_WEB = "APP/PROC/WEB";
    private boolean onCloudFoundry;
    private String spaceId;
    private String spaceName;
    private String organizationId;
    private String organizationName;
    private String applicationId;
    private String applicationName;
    private String instanceId;
    private String instanceIndex;
    private String clusterEnv;
    private String clusterEngine;
    private String clusterEngineVersion;
    private String clusterName;
    private String clusterNetworkZone;
    private String clusterDatacenter;

    public void start() {
        super.start();
        String vcapApplication = System.getenv("VCAP_APPLICATION");
        if (vcapApplication != null) {
            this.onCloudFoundry = true;
            JsonParser jsonParser = JsonParserFactory.getJsonParser();
            Map map = jsonParser.parseMap(vcapApplication);
            this.applicationId = (String)map.get("application_id");
            this.applicationName = (String)map.get("application_name");
            this.spaceId = (String)map.get("space_id");
            this.spaceName = (String)map.get("space_name");
            this.organizationId = (String)map.get("organization_id");
            this.organizationName = (String)map.get("organization_name");
            this.instanceId = System.getenv("CF_INSTANCE_GUID");
            this.instanceIndex = System.getenv("CF_INSTANCE_INDEX");
            this.clusterEnv = this.getOrDefault(System.getenv("CF_CLUSTER_ENV"), "prod");
            this.clusterEngine = this.getOrDefault(System.getenv("CF_CLUSTER_ENGINE"), "caasp");
            this.clusterEngineVersion = this.getOrDefault(System.getenv("CF_CLUSTER_ENGINE_VERSION"), "v4");
            this.clusterName = this.getOrDefault(System.getenv("CF_CLUSTER_NAME"), "ccp02");
            this.clusterNetworkZone = this.getOrDefault(System.getenv("CF_CLUSTER_NETWORK_ZONE"), "ssz");
            this.clusterDatacenter = this.getOrDefault(System.getenv("CF_CLUSTER_DATACENTER"), "primus");
        }
    }

    public void writeTo(JsonGenerator generator, ILoggingEvent iLoggingEvent) throws IOException {
        if (this.onCloudFoundry) {
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_APP_ID, (String)this.applicationId);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_APP_NAME, (String)this.applicationName);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_SPACE_ID, (String)this.spaceId);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_SPACE_NAME, (String)this.spaceName);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_ORG_ID, (String)this.organizationId);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_ORG_NAME, (String)this.organizationName);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CF_INSTANCE_ID, (String)this.instanceId);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_ENV, (String)this.clusterEnv);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_ENGINE, (String)this.clusterEngine);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_ENGINE_VERSION, (String)this.clusterEngineVersion);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_NAME, (String)this.clusterName);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_NETWORK_ZONE, (String)this.clusterNetworkZone);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)CLUSTER_DATACENTER, (String)this.clusterDatacenter);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)SOURCE_INSTANCE, (String)this.instanceIndex);
            JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)SOURCE_TYPE, (String)APP_PROC_WEB);
        }
    }

    private String getOrDefault(String value, String ifEmpty) {
        return value == null || value.isBlank() ? ifEmpty : value;
    }
}

