/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.aws;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.JsonWritingUtils;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.web.client.RestClient;

public class EcsContainerMetadataAttributeProvider
extends AbstractJsonProvider<ILoggingEvent> {
    private static final String TASK_DEFINITION_VERSION = "taskDefinitionVersion";
    private String taskDefinitionVersion;

    public void start() {
        RestClient restClient;
        String ecsContainerMetadata;
        super.start();
        String ecsContainerMetadataUriV4 = System.getenv("ECS_CONTAINER_METADATA_URI_V4");
        if (ecsContainerMetadataUriV4 != null && (ecsContainerMetadata = (String)(restClient = RestClient.create()).get().uri(ecsContainerMetadataUriV4, new Object[0]).retrieve().body(String.class)) != null) {
            this.taskDefinitionVersion = EcsContainerMetadataAttributeProvider.parseTaskDefinitionVersion(ecsContainerMetadata);
        }
    }

    public void writeTo(JsonGenerator generator, ILoggingEvent iLoggingEvent) throws IOException {
        JsonWritingUtils.writeStringField((JsonGenerator)generator, (String)TASK_DEFINITION_VERSION, (String)this.taskDefinitionVersion);
    }

    protected static String parseTaskDefinitionVersion(String ecsContainerMetadata) {
        if (ecsContainerMetadata != null) {
            try {
                JsonParser jsonParser = JsonParserFactory.getJsonParser();
                Map map = jsonParser.parseMap(ecsContainerMetadata);
                Map labelsMap = (Map)map.get("Labels");
                return (String)labelsMap.get("com.amazonaws.ecs.task-definition-version");
            }
            catch (ClassCastException castException) {
                return "";
            }
        }
        return "";
    }
}

