/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.syslog;

import ch.admin.bit.jeap.log.syslog.connection.TLSSyslogConnection;
import ch.admin.bit.jeap.log.syslog.connection.TLSSyslogConnectionProperties;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.ssl.SSLComponent;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class TLSSyslogAppender
extends AppenderBase<ILoggingEvent>
implements SSLComponent {
    private static final int DEFAULT_PORT = 6514;
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_TCP_KEEPALIVE_IDLE_SECONDS = 20;
    private static final int MAX_MESSAGE_SIZE_LIMIT = 65000;
    private String syslogHost;
    private int port = 6514;
    private int timeoutMillis = 5000;
    private int tcpKeepIdleSeconds = 20;
    private int maxMessageSize = 65000;
    private Encoder<ILoggingEvent> encoder;
    private SSLConfiguration ssl = new SSLConfiguration();
    private TLSSyslogConnection syslogConnection;
    private static final Map<String, TLSSyslogConnection> CONNECTIONS = new ConcurrentHashMap<String, TLSSyslogConnection>();

    protected void append(ILoggingEvent eventObject) {
        byte[] syslogMessage = this.encoder.encode((Object)eventObject);
        this.transmit(syslogMessage);
    }

    protected void transmit(byte[] syslogMessage) {
        byte[] maxLengthSyslogMessage = syslogMessage;
        if (syslogMessage.length > this.maxMessageSize) {
            maxLengthSyslogMessage = Arrays.copyOfRange(syslogMessage, 0, this.maxMessageSize);
        }
        this.syslogConnection.transmit(maxLengthSyslogMessage);
    }

    public void start() {
        if (this.syslogHost == null) {
            throw new IllegalArgumentException("syslogHost must be configured for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.encoder == null) {
            throw new IllegalArgumentException("an encoder must be configured for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        try {
            TLSSyslogAppender contextAware = this;
            this.syslogConnection = this.createOrReuseSyslogConnection((ContextAware)contextAware);
            super.start();
        }
        catch (Exception e) {
            this.addError(String.format("Error starting %s using syslog host %s:%d", ((Object)((Object)this)).getClass().getSimpleName(), this.syslogHost, this.port), e);
        }
    }

    private TLSSyslogConnection createOrReuseSyslogConnection(ContextAware contextAware) throws GeneralSecurityException {
        String syslogHostPortKey = this.getName() + ":" + this.syslogHost + ":" + this.port;
        TLSSyslogConnection existingConnection = CONNECTIONS.get(syslogHostPortKey);
        if (existingConnection != null) {
            System.out.println("Reusing syslog connection to " + syslogHostPortKey);
            return existingConnection;
        }
        TLSSyslogConnection newConnection = this.connectToSyslog(contextAware);
        CONNECTIONS.put(syslogHostPortKey, newConnection);
        return newConnection;
    }

    private TLSSyslogConnection connectToSyslog(ContextAware contextAware) throws GeneralSecurityException {
        TLSSyslogConnection newConnection = this.createSyslogConnection(contextAware);
        if (!newConnection.attemptConnection()) {
            newConnection.attemptConnection();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(newConnection::disconnect));
        return newConnection;
    }

    protected TLSSyslogConnection createSyslogConnection(ContextAware contextAware) throws GeneralSecurityException {
        TLSSyslogConnectionProperties props = TLSSyslogConnectionProperties.builder().syslogHost(this.syslogHost).port(this.port).ssl(this.getSsl()).timeoutMillis(this.timeoutMillis).tcpKeepIdleSeconds(this.tcpKeepIdleSeconds).build();
        return TLSSyslogConnection.create(contextAware, props);
    }

    static void cleanConnectionCache() {
        CONNECTIONS.values().forEach(TLSSyslogConnection::disconnect);
        CONNECTIONS.clear();
    }

    @Generated
    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Generated
    public void setTcpKeepIdleSeconds(int tcpKeepIdleSeconds) {
        this.tcpKeepIdleSeconds = tcpKeepIdleSeconds;
    }

    @Generated
    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Generated
    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    @Generated
    public void setSsl(SSLConfiguration ssl) {
        this.ssl = ssl;
    }

    @Generated
    public SSLConfiguration getSsl() {
        return this.ssl;
    }
}

