/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.log.metrics;

import ch.admin.bit.jeap.log.metrics.LoggingMetricsProvider;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;

class MicrometerLoggingMetricsProvider
implements LoggingMetricsProvider {
    private static final String DIST_LOG_CONNECTION_ERROR = "logging_distlog_connection_error";
    private static final String DIST_LOG_CONNECTION_ESTABLISHED = "logging_distlog_connection_established";
    private static final String DIST_LOG_TRANSMIT_ERROR = "logging_distlog_transmit_error";
    private static final String DIST_LOG_TRANSMIT_TIME = "logging_distlog_transmit_time";
    private final Counter distLogConnectionError;
    private final Counter distLogConnectionEstablished;
    private final Counter distLogTransmitError;
    private final Timer logTransmitTimer;

    MicrometerLoggingMetricsProvider(Object meterRegistryBean) {
        MeterRegistry meterRegistry = (MeterRegistry)meterRegistryBean;
        this.distLogConnectionError = Counter.builder((String)DIST_LOG_CONNECTION_ERROR).register(meterRegistry);
        this.distLogConnectionEstablished = Counter.builder((String)DIST_LOG_CONNECTION_ESTABLISHED).register(meterRegistry);
        this.distLogTransmitError = Counter.builder((String)DIST_LOG_TRANSMIT_ERROR).register(meterRegistry);
        this.logTransmitTimer = Timer.builder((String)DIST_LOG_TRANSMIT_TIME).publishPercentiles(new double[]{0.5, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofHours(24L)).register(meterRegistry);
    }

    @Override
    public void incrementDistributedLogConnectionEstablished() {
        this.distLogConnectionEstablished.increment();
    }

    @Override
    public void incrementDistributedLogConnectionError() {
        this.distLogConnectionError.increment();
    }

    @Override
    public void incrementDistributedLogTransmitError() {
        this.distLogTransmitError.increment();
    }

    @Override
    public void distributedLogTransmitTime(Duration duration) {
        this.logTransmitTimer.record(duration);
    }
}

