/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.semanticAuthentication;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class SemanticApplicationRole {
    private final String system;
    private final String tenant;
    private final String resource;
    private final String operation;

    private static SemanticApplicationRole create(@NonNull String system, String tenant, @NonNull String resource, @NonNull String operation) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        return new SemanticApplicationRole(system, tenant, resource, operation);
    }

    static Optional<SemanticApplicationRole> fromTokenRole(String tokenRole) {
        String operation;
        String resource;
        String[] splitsArray = tokenRole.split("_");
        int index = 0;
        String system = splitsArray[index++];
        String tenant = SemanticApplicationRole.fetchElementStartsWith(splitsArray, index, '%');
        if (tenant != null) {
            ++index;
        }
        if ((resource = SemanticApplicationRole.fetchElementStartsWith(splitsArray, index, '@')) != null) {
            ++index;
        }
        if ((operation = SemanticApplicationRole.fetchElementStartsWith(splitsArray, index, '#')) != null) {
            ++index;
        }
        if (splitsArray.length > index) {
            return Optional.empty();
        }
        SemanticApplicationRole role = new SemanticApplicationRole(system, tenant, resource, operation);
        return Optional.of(role);
    }

    private static String fetchElementStartsWith(String[] splits, int index, char startWith) {
        if (splits.length <= index) {
            return null;
        }
        if (splits[index].charAt(0) == startWith) {
            return splits[index].substring(1);
        }
        return null;
    }

    boolean includes(SemanticApplicationRole roleToCheckAgainst) {
        return this.sameSystem(roleToCheckAgainst.getSystem()) && this.sameTenantOrWildcard(roleToCheckAgainst.getTenant()) && this.sameResourceOrWildcard(roleToCheckAgainst.getResource()) && this.sameOperationOrWildcard(roleToCheckAgainst.getOperation());
    }

    boolean matches(SemanticApplicationRole roleToMatch) {
        return !(!roleToMatch.sameSystem(this.system) || this.tenant != null && !roleToMatch.sameTenantOrWildcard(this.tenant) || this.resource != null && !roleToMatch.sameResourceOrWildcard(this.resource) || this.operation != null && !roleToMatch.sameOperationOrWildcard(this.operation));
    }

    boolean sameSystem(String system) {
        return this.system.equals(system);
    }

    boolean sameTenantOrWildcard(String tenant) {
        return this.tenant == null || this.tenant.equals(tenant);
    }

    boolean sameResourceOrWildcard(String resource) {
        return this.resource == null || this.resource.equals(resource);
    }

    boolean sameOperationOrWildcard(String operation) {
        return this.operation == null || this.operation.equals(operation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.system);
        if (this.tenant != null) {
            sb.append("_%");
            sb.append(this.tenant);
        }
        if (this.resource != null) {
            sb.append("_@");
            sb.append(this.resource);
        }
        if (this.operation != null) {
            sb.append("_#");
            sb.append(this.operation);
        }
        return sb.toString();
    }

    @Generated
    public static SemanticApplicationRoleBuilder builder() {
        return new SemanticApplicationRoleBuilder();
    }

    @Generated
    public String getSystem() {
        return this.system;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticApplicationRole)) {
            return false;
        }
        SemanticApplicationRole other = (SemanticApplicationRole)o;
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        String $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        return result;
    }

    @Generated
    SemanticApplicationRole(String system, String tenant, String resource, String operation) {
        this.system = system;
        this.tenant = tenant;
        this.resource = resource;
        this.operation = operation;
    }

    @Generated
    public static class SemanticApplicationRoleBuilder {
        @Generated
        private String system;
        @Generated
        private String tenant;
        @Generated
        private String resource;
        @Generated
        private String operation;

        @Generated
        SemanticApplicationRoleBuilder() {
        }

        @Generated
        public SemanticApplicationRoleBuilder system(@NonNull String system) {
            if (system == null) {
                throw new NullPointerException("system is marked non-null but is null");
            }
            this.system = system;
            return this;
        }

        @Generated
        public SemanticApplicationRoleBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        @Generated
        public SemanticApplicationRoleBuilder resource(@NonNull String resource) {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.resource = resource;
            return this;
        }

        @Generated
        public SemanticApplicationRoleBuilder operation(@NonNull String operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            this.operation = operation;
            return this;
        }

        @Generated
        public SemanticApplicationRole build() {
            return SemanticApplicationRole.create(this.system, this.tenant, this.resource, this.operation);
        }

        @Generated
        public String toString() {
            return "SemanticApplicationRole.SemanticApplicationRoleBuilder(system=" + this.system + ", tenant=" + this.tenant + ", resource=" + this.resource + ", operation=" + this.operation + ")";
        }
    }
}

