/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.token;

import org.springframework.security.oauth2.jwt.Jwt;

public enum JeapAuthenticationContext {
    SYS,
    B2B,
    USER;

    private static final String CONTEXT_CLAIM_NAME = "ctx";

    public static JeapAuthenticationContext readFromJwt(Jwt jwt) throws IllegalArgumentException {
        String context = jwt.getClaimAsString(CONTEXT_CLAIM_NAME);
        if (context == null) {
            throw new IllegalArgumentException("Context claim 'ctx' is missing from the JWT.");
        }
        return JeapAuthenticationContext.valueOf(context);
    }

    public static boolean isB2B(Jwt jwt) {
        try {
            return JeapAuthenticationContext.readFromJwt(jwt).equals((Object)B2B);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getContextJwtClaimName() {
        return CONTEXT_CLAIM_NAME;
    }
}

