/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;

public class ContextIssuerJwtValidator
implements OAuth2TokenValidator<Jwt> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextIssuerJwtValidator.class);
    private final JwtIssuerValidator jwtIssuerValidator;
    private final List<JeapAuthenticationContext> contexts;

    ContextIssuerJwtValidator(Collection<JeapAuthenticationContext> contexts, String issuer) {
        this.contexts = new ArrayList<JeapAuthenticationContext>(contexts);
        this.jwtIssuerValidator = new JwtIssuerValidator(issuer);
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        try {
            JeapAuthenticationContext context = JeapAuthenticationContext.readFromJwt(jwt);
            if (!this.contexts.contains((Object)context)) {
                return this.createErrorResult("Unsupported context claim value '" + String.valueOf((Object)context) + "'.");
            }
            return this.jwtIssuerValidator.validate(jwt);
        }
        catch (IllegalArgumentException e) {
            return this.createErrorResult(e.getMessage());
        }
    }

    private OAuth2TokenValidatorResult createErrorResult(String errorMessage) {
        OAuth2Error error = new OAuth2Error("invalid_token", errorMessage, null);
        log.warn(error.getDescription());
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
    }
}

