/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.restclient;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public class OAuth2ClientCredentialsRestClientInitializer
implements ClientHttpRequestInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientCredentialsRestClientInitializer.class);
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private final ClientRegistration clientRegistration;
    private final boolean preferTokenFromIncomingRequest;

    public OAuth2ClientCredentialsRestClientInitializer(OAuth2AuthorizedClientManager authorizedClientManager, ClientRegistration clientRegistration, boolean preferTokenFromIncomingRequest) {
        this.authorizedClientManager = authorizedClientManager;
        this.clientRegistration = clientRegistration;
        this.preferTokenFromIncomingRequest = preferTokenFromIncomingRequest;
    }

    public void initialize(@NonNull ClientHttpRequest request) {
        if (this.preferTokenFromIncomingRequest && request.getHeaders().containsKey((Object)"Authorization")) {
            log.trace("The configuration preferTokenFromIncomingRequest is true: reusing the token from incoming request...");
        } else {
            String clientRegistrationId = this.clientRegistration.getRegistrationId();
            OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal(this.clientRegistration.getClientId()).build();
            OAuth2AuthorizedClient authorizedClient = this.authorizedClientManager.authorize(authorizeRequest);
            if (authorizedClient == null) {
                throw new IllegalStateException("client credentials flow on " + clientRegistrationId + " failed, client is null");
            }
            request.getHeaders().setBearerAuth(authorizedClient.getAccessToken().getTokenValue());
        }
    }
}

