/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.configuration;

import ch.admin.bit.jeap.security.resource.configuration.MvcSecurityConfiguration;
import ch.admin.bit.jeap.security.resource.configuration.WebFluxSecurityConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.HttpStatusServerEntryPoint;

@AutoConfiguration(after={MvcSecurityConfiguration.class, WebFluxSecurityConfiguration.class})
public class DefaultDenyAllWebSecurityConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDenyAllWebSecurityConfiguration.class);
    private static final String DENY_ALL_MESSAGE = "jeap-spring-boot-security-starter did not activate OAuth2 resource security for web endpoints. Activating a 'deny-all' configuration as secure fallback. Override the 'deny-all' configuration with your own web security configuration or define the configuration properties needed for the OAuth2 resource security.";

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnMissingBean(value={WebFluxSecurityConfiguration.class})
    @EnableWebFluxSecurity
    public static class WebFluxDenyAllWebSecurityConfiguration {
        @Bean
        @Order(value=0x7FFFFFFF)
        public SecurityWebFilterChain denyAllSecurityWebFilterChain(ServerHttpSecurity http) {
            log.debug(DefaultDenyAllWebSecurityConfiguration.DENY_ALL_MESSAGE);
            http.authorizeExchange(exchanges -> exchanges.anyExchange().denyAll()).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)new HttpStatusServerEntryPoint(HttpStatus.FORBIDDEN)));
            return http.build();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnMissingBean(value={MvcSecurityConfiguration.class})
    @EnableWebSecurity
    public static class WebMvcDenyAllWebSecurityConfiguration {
        @Bean
        @Order(value=0x7FFFFFFF)
        public SecurityFilterChain oauth2SecurityWebFilterChain(HttpSecurity http) throws Exception {
            log.debug(DefaultDenyAllWebSecurityConfiguration.DENY_ALL_MESSAGE);
            http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.anyRequest()).denyAll()).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.FORBIDDEN)));
            return (SecurityFilterChain)http.build();
        }
    }
}

