/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.token;

import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JeapAuthenticationToken
extends JwtAuthenticationToken {
    private final Map<String, Set<String>> businessPartnerRoles;
    private final Set<String> userRoles;

    public JeapAuthenticationToken(Jwt jwt, Set<String> userRoles, Map<String, Set<String>> businessPartnerRoles, Collection<? extends GrantedAuthority> grantedAuthorities) {
        super(jwt, grantedAuthorities);
        this.businessPartnerRoles = Collections.unmodifiableMap(businessPartnerRoles);
        this.userRoles = Collections.unmodifiableSet(userRoles);
    }

    public String getClientId() {
        return ((Jwt)this.getToken()).getClaimAsString("clientId");
    }

    public String getTokenExtId() {
        return ((Jwt)this.getToken()).getClaimAsString("ext_id");
    }

    public String getAdminDirUID() {
        return ((Jwt)this.getToken()).getClaimAsString("admin_dir_uid");
    }

    public String getTokenName() {
        return ((Jwt)this.getToken()).getClaimAsString("name");
    }

    public String getTokenGivenName() {
        return ((Jwt)this.getToken()).getClaimAsString("given_name");
    }

    public String getTokenFamilyName() {
        return ((Jwt)this.getToken()).getClaimAsString("family_name");
    }

    public String getPreferredUsername() {
        return ((Jwt)this.getToken()).getClaimAsString("preferred_username");
    }

    public String getTokenSubject() {
        return ((Jwt)this.getToken()).getClaimAsString("sub");
    }

    public String getTokenLocale() {
        return ((Jwt)this.getToken()).getClaimAsString("locale");
    }

    public JeapAuthenticationContext getJeapAuthenticationContext() {
        return JeapAuthenticationContext.readFromJwt((Jwt)this.getToken());
    }

    public Map<String, Set<String>> getBusinessPartnerRoles() {
        return this.businessPartnerRoles;
    }

    public Set<String> getUserRoles() {
        return this.userRoles;
    }

    public String toString() {
        return String.format("JeapAuthenticationToken{ subject (calling user): %s, client (calling system): %s, context: %s, authorities (all roles): %s, user roles: %s, business partner roles: %s }", new Object[]{this.getName(), this.getClientId(), this.getJeapAuthenticationContext(), this.authoritiesToString(), this.userRolesToString(), this.businessPartnerRolesToString()});
    }

    private String authoritiesToString() {
        return this.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(a -> "'" + a + "'").collect(Collectors.joining(","));
    }

    private String businessPartnerRolesToString() {
        return this.getBusinessPartnerRoles().entrySet().stream().map(e -> (String)e.getKey() + " [ " + ((Set)e.getValue()).stream().map(r -> "'" + r + "'").collect(Collectors.joining(", ")) + " ]").collect(Collectors.joining(", "));
    }

    private String userRolesToString() {
        return this.getUserRoles().stream().map(r -> "'" + r + "'").collect(Collectors.joining(", "));
    }
}

