/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.configuration;

import ch.admin.bit.jeap.security.resource.authentication.ReactiveSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.configuration.JeapMethodSecurityExpressionHandlerCustomizer;
import ch.admin.bit.jeap.security.resource.configuration.JeapOAuth2ResourceCondition;
import ch.admin.bit.jeap.security.resource.configuration.JeapOauth2ResourceServerAccessDeniedHandler;
import ch.admin.bit.jeap.security.resource.configuration.JeapOauth2ResourceServerAuthenticationEntryPoint;
import ch.admin.bit.jeap.security.resource.configuration.SemanticAuthorizationCondition;
import ch.admin.bit.jeap.security.resource.configuration.SemanticMethodSecurityExpressionHandler;
import ch.admin.bit.jeap.security.resource.configuration.SimpleMethodSecurityExpressionHandler;
import ch.admin.bit.jeap.security.resource.log.LoggingBearerTokenServerAccessDeniedHandler;
import ch.admin.bit.jeap.security.resource.log.LoggingBearerTokenServerAuthenticationEntryPoint;
import ch.admin.bit.jeap.security.resource.properties.ResourceServerProperties;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ReactiveSemanticAuthorization;
import ch.admin.bit.jeap.security.resource.token.AuthoritiesResolver;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationConverter;
import ch.admin.bit.jeap.security.resource.validation.JeapJwtDecoderFactory;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.csrf.CookieServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;

@AutoConfiguration
@Conditional(value={JeapOAuth2ResourceCondition.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
public class WebFluxSecurityConfiguration {
    private final ResourceServerProperties resourceServerProperties;
    private final ApplicationContext context;
    private final Environment environment;
    private final AuthoritiesResolver authoritiesResolver;
    private final Optional<JeapMethodSecurityExpressionHandlerCustomizer> expressionHandlerCustomizer;

    @Bean
    public JeapJwtDecoderFactory jeapJwtDecoderFactory() {
        return new JeapJwtDecoderFactory(this.context, this.resourceServerProperties);
    }

    @Bean
    public ReactiveSimpleAuthorization jeapSimpleAuthorization() {
        return new ReactiveSimpleAuthorization();
    }

    @Bean
    @Conditional(value={SemanticAuthorizationCondition.class})
    public ReactiveSemanticAuthorization jeapSemanticAuthorization() {
        return new ReactiveSemanticAuthorization(this.resourceServerProperties.getSystemName());
    }

    @Bean
    @Primary
    public MethodSecurityExpressionHandler customMethodSecurityExpressionHandler() {
        DefaultMethodSecurityExpressionHandler expressionHandler = SemanticAuthorizationCondition.isSemanticAuthorizationEnabled(this.environment) ? new SemanticMethodSecurityExpressionHandler(this.resourceServerProperties.getSystemName()) : new SimpleMethodSecurityExpressionHandler();
        expressionHandler.setApplicationContext(this.context);
        return this.customize(expressionHandler);
    }

    private MethodSecurityExpressionHandler customize(DefaultMethodSecurityExpressionHandler expressionHandler) {
        if (this.expressionHandlerCustomizer.isPresent()) {
            return this.expressionHandlerCustomizer.get().customize(expressionHandler);
        }
        return expressionHandler;
    }

    @ConditionalOnProperty(value={"jeap.security.oauth2.resourceserver.log.authentication-failure.enabled"})
    @ConditionalOnMissingBean(value={JeapOauth2ResourceServerAuthenticationEntryPoint.class})
    @Bean
    public JeapOauth2ResourceServerAuthenticationEntryPoint jeapOauth2ResourceServerAuthenticationEntryPoint() {
        return new LoggingBearerTokenServerAuthenticationEntryPoint();
    }

    @ConditionalOnProperty(value={"jeap.security.oauth2.resourceserver.log.access-denied.enabled"})
    @ConditionalOnMissingBean(value={JeapOauth2ResourceServerAccessDeniedHandler.class})
    @Bean
    public JeapOauth2ResourceServerAccessDeniedHandler jeapOauth2ResourceServerAccessDeniedHandler(@Value(value="${jeap.security.oauth2.resourceserver.log.access-denied.debug:false}") boolean debugEnabled) {
        return new LoggingBearerTokenServerAccessDeniedHandler(debugEnabled);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public SecurityWebFilterChain oauth2SecurityWebFilterChain(ServerHttpSecurity http, JeapJwtDecoderFactory jeapJwtDecoderFactory, Optional<JeapOauth2ResourceServerAuthenticationEntryPoint> oauth2ResourceServerAuthenticationEntryPoint, Optional<JeapOauth2ResourceServerAccessDeniedHandler> oauth2ResourceServerAccessDeniedHandler) {
        http.authorizeExchange(exchanges -> exchanges.anyExchange().authenticated());
        http.cors(Customizer.withDefaults());
        http.csrf(csrf -> csrf.csrfTokenRepository((ServerCsrfTokenRepository)CookieServerCsrfTokenRepository.withHttpOnlyFalse()));
        ReactiveJwtDecoder jwtDecoder = jeapJwtDecoderFactory.createReactiveJwtDecoder();
        ReactiveJwtAuthenticationConverterAdapter authenticationConverter = new ReactiveJwtAuthenticationConverterAdapter((Converter)new JeapAuthenticationConverter(this.authoritiesResolver));
        http.oauth2ResourceServer(oAuth2ResourceServer -> {
            oAuth2ResourceServer.jwt(jwt -> jwt.jwtDecoder(jwtDecoder).jwtAuthenticationConverter((Converter)authenticationConverter));
            oauth2ResourceServerAuthenticationEntryPoint.ifPresent(arg_0 -> ((ServerHttpSecurity.OAuth2ResourceServerSpec)oAuth2ResourceServer).authenticationEntryPoint(arg_0));
            oauth2ResourceServerAccessDeniedHandler.ifPresent(arg_0 -> ((ServerHttpSecurity.OAuth2ResourceServerSpec)oAuth2ResourceServer).accessDeniedHandler(arg_0));
        });
        return http.build();
    }

    @Generated
    public WebFluxSecurityConfiguration(ResourceServerProperties resourceServerProperties, ApplicationContext context, Environment environment, AuthoritiesResolver authoritiesResolver, Optional<JeapMethodSecurityExpressionHandlerCustomizer> expressionHandlerCustomizer) {
        this.resourceServerProperties = resourceServerProperties;
        this.context = context;
        this.environment = environment;
        this.authoritiesResolver = authoritiesResolver;
        this.expressionHandlerCustomizer = expressionHandlerCustomizer;
    }
}

