/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.client;

import ch.admin.bit.jeap.security.client.JeapOAuth2WebclientBuilderFactory;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public class DefaultJeapOAuth2WebclientBuilderFactory
implements JeapOAuth2WebclientBuilderFactory {
    private final WebClient.Builder webClientBuilder;
    private final ExchangeFilterFunction oauth2ClientExchangeFilterFunction;
    private final ExchangeFilterFunction bearerFromAuthenticationExchangeFilterFunction;
    private final ClientRegistrationResolver clientRegistrationResolver;

    public DefaultJeapOAuth2WebclientBuilderFactory(WebClient.Builder webClientBuilder, @NonNull ExchangeFilterFunction oauth2ClientExchangeFilterFunction, @NonNull ExchangeFilterFunction bearerFromAuthenticationExchangeFilterFunction, @NonNull ClientRegistrationResolver clientRegistrationResolver) {
        if (oauth2ClientExchangeFilterFunction == null) {
            throw new NullPointerException("oauth2ClientExchangeFilterFunction is marked non-null but is null");
        }
        if (bearerFromAuthenticationExchangeFilterFunction == null) {
            throw new NullPointerException("bearerFromAuthenticationExchangeFilterFunction is marked non-null but is null");
        }
        if (clientRegistrationResolver == null) {
            throw new NullPointerException("clientRegistrationResolver is marked non-null but is null");
        }
        this.webClientBuilder = Objects.requireNonNull(webClientBuilder).clone();
        this.oauth2ClientExchangeFilterFunction = oauth2ClientExchangeFilterFunction;
        this.bearerFromAuthenticationExchangeFilterFunction = bearerFromAuthenticationExchangeFilterFunction;
        this.clientRegistrationResolver = clientRegistrationResolver;
    }

    public DefaultJeapOAuth2WebclientBuilderFactory(WebClient.Builder webClientBuilder, @NonNull ExchangeFilterFunction bearerFromAuthenticationExchangeFilterFunction) {
        if (bearerFromAuthenticationExchangeFilterFunction == null) {
            throw new NullPointerException("bearerFromAuthenticationExchangeFilterFunction is marked non-null but is null");
        }
        this.webClientBuilder = Objects.requireNonNull(webClientBuilder).clone();
        this.bearerFromAuthenticationExchangeFilterFunction = bearerFromAuthenticationExchangeFilterFunction;
        this.oauth2ClientExchangeFilterFunction = null;
        this.clientRegistrationResolver = null;
    }

    @Override
    public WebClient.Builder createForClientId(String clientRegistryId) {
        return this.createForClientRegistryId(clientRegistryId);
    }

    @Override
    public WebClient.Builder createForClientRegistryId(String clientRegistryId) {
        this.assertOAuth2ClientConfigured(clientRegistryId);
        return this.webClientBuilder.clone().filter((request, next) -> next.exchange(ClientRequest.from((ClientRequest)request).attributes(ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId((String)clientRegistryId)).build())).filter(this.oauth2ClientExchangeFilterFunction);
    }

    @Override
    public WebClient.Builder createForClientIdPreferringTokenFromIncomingRequest(String clientRegistryId) {
        return this.createForClientRegistryIdPreferringTokenFromIncomingRequest(clientRegistryId);
    }

    @Override
    public WebClient.Builder createForClientRegistryIdPreferringTokenFromIncomingRequest(String clientRegistryId) {
        this.assertOAuth2ClientConfigured(clientRegistryId);
        return this.webClientBuilder.clone().filter((request, next) -> next.exchange(ClientRequest.from((ClientRequest)request).attributes(ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId((String)clientRegistryId)).build())).filter(this.bearerFromAuthenticationExchangeFilterFunction).filter((request, next) -> {
            if (!request.headers().containsKey((Object)"Authorization")) {
                return this.oauth2ClientExchangeFilterFunction.filter(request, next);
            }
            return next.exchange(request);
        });
    }

    @Override
    public WebClient.Builder createForTokenFromIncomingRequest() {
        return this.webClientBuilder.clone().filter(this.bearerFromAuthenticationExchangeFilterFunction);
    }

    private void assertOAuth2ClientConfigured(String clientRegistryId) {
        if (this.oauth2ClientExchangeFilterFunction == null) {
            throw new UnsupportedOperationException("Application not configured as OAuth2 client.");
        }
        if (this.clientRegistrationResolver.findByRegistrationId(clientRegistryId) == null) {
            throw new IllegalArgumentException("There is no client registration with id '" + clientRegistryId + "' configured.");
        }
    }

    @FunctionalInterface
    public static interface ClientRegistrationResolver {
        public ClientRegistration findByRegistrationId(String var1);
    }
}

