/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.validation.JeapTokenValidationException;
import ch.admin.bit.jeap.security.resource.validation.RawJwtTokenParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

class IssuerJwtDecoder
implements JwtDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuerJwtDecoder.class);
    private final Map<String, JwtDecoder> issuerDecoderMap;

    private IssuerJwtDecoder(Map<String, JwtDecoder> issuerDecoderMap) {
        if (issuerDecoderMap.isEmpty()) {
            throw new IllegalStateException("At least one decoder must be configured.");
        }
        this.issuerDecoderMap = issuerDecoderMap;
    }

    public Jwt decode(String token) {
        String issuer = RawJwtTokenParser.extractIssuer(token);
        JwtDecoder decoder = this.issuerDecoderMap.get(issuer);
        if (decoder != null) {
            log.debug("Decoding a token from issuer '{}'.", (Object)issuer);
            Jwt jwt = decoder.decode(token);
            log.debug("Decoded token from issuer '{}' for subject '{}'.", (Object)jwt.getIssuer(), (Object)jwt.getSubject());
            return jwt;
        }
        throw new JeapTokenValidationException("Unsupported issuer '" + issuer + "'. There is no JwtDecoder configured for it.");
    }

    @Generated
    public static IssuerJwtDecoderBuilder builder() {
        return new IssuerJwtDecoderBuilder();
    }

    @Generated
    public static class IssuerJwtDecoderBuilder {
        @Generated
        private ArrayList<String> issuerDecoderMap$key;
        @Generated
        private ArrayList<JwtDecoder> issuerDecoderMap$value;

        @Generated
        IssuerJwtDecoderBuilder() {
        }

        @Generated
        public IssuerJwtDecoderBuilder issuerDecoder(String issuerDecoderKey, JwtDecoder issuerDecoderValue) {
            if (this.issuerDecoderMap$key == null) {
                this.issuerDecoderMap$key = new ArrayList();
                this.issuerDecoderMap$value = new ArrayList();
            }
            this.issuerDecoderMap$key.add(issuerDecoderKey);
            this.issuerDecoderMap$value.add(issuerDecoderValue);
            return this;
        }

        @Generated
        public IssuerJwtDecoderBuilder issuerDecoderMap(Map<? extends String, ? extends JwtDecoder> issuerDecoderMap) {
            if (issuerDecoderMap == null) {
                throw new NullPointerException("issuerDecoderMap cannot be null");
            }
            if (this.issuerDecoderMap$key == null) {
                this.issuerDecoderMap$key = new ArrayList();
                this.issuerDecoderMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends JwtDecoder> $lombokEntry : issuerDecoderMap.entrySet()) {
                this.issuerDecoderMap$key.add($lombokEntry.getKey());
                this.issuerDecoderMap$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public IssuerJwtDecoderBuilder clearIssuerDecoderMap() {
            if (this.issuerDecoderMap$key != null) {
                this.issuerDecoderMap$key.clear();
                this.issuerDecoderMap$value.clear();
            }
            return this;
        }

        @Generated
        public IssuerJwtDecoder build() {
            Map<String, JwtDecoder> issuerDecoderMap;
            switch (this.issuerDecoderMap$key == null ? 0 : this.issuerDecoderMap$key.size()) {
                case 0: {
                    issuerDecoderMap = Collections.emptyMap();
                    break;
                }
                case 1: {
                    issuerDecoderMap = Collections.singletonMap(this.issuerDecoderMap$key.get(0), this.issuerDecoderMap$value.get(0));
                    break;
                }
                default: {
                    issuerDecoderMap = new LinkedHashMap<String, JwtDecoder>(this.issuerDecoderMap$key.size() < 0x40000000 ? 1 + this.issuerDecoderMap$key.size() + (this.issuerDecoderMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.issuerDecoderMap$key.size(); ++$i) {
                        issuerDecoderMap.put(this.issuerDecoderMap$key.get($i), this.issuerDecoderMap$value.get($i));
                    }
                    issuerDecoderMap = Collections.unmodifiableMap(issuerDecoderMap);
                }
            }
            return new IssuerJwtDecoder(issuerDecoderMap);
        }

        @Generated
        public String toString() {
            return "IssuerJwtDecoder.IssuerJwtDecoderBuilder(issuerDecoderMap$key=" + String.valueOf(this.issuerDecoderMap$key) + ", issuerDecoderMap$value=" + String.valueOf(this.issuerDecoderMap$value) + ")";
        }
    }
}

