/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.semanticAuthentication;

import ch.admin.bit.jeap.security.resource.semanticAuthentication.SemanticApplicationRole;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SemanticRoleRepository {
    private final Map<String, Set<SemanticApplicationRole>> businessPartnerRoles;
    private final Set<SemanticApplicationRole> userRoles;
    private final String systemName;

    public SemanticRoleRepository(String systemName, JeapAuthenticationToken jeapAuthenticationToken) {
        this.userRoles = jeapAuthenticationToken.getUserRoles().stream().map(SemanticApplicationRole::fromTokenRole).filter(Optional::isPresent).map(Optional::get).filter(r -> r.sameSystem(systemName)).collect(Collectors.toSet());
        HashMap<String, Set<SemanticApplicationRole>> businessPartnerRoles = new HashMap<String, Set<SemanticApplicationRole>>();
        jeapAuthenticationToken.getBusinessPartnerRoles().forEach((partner, roleList) -> businessPartnerRoles.put((String)partner, roleList.stream().map(SemanticApplicationRole::fromTokenRole).filter(Optional::isPresent).map(Optional::get).filter(r -> r.sameSystem(systemName)).collect(Collectors.toSet())));
        this.businessPartnerRoles = businessPartnerRoles;
        this.systemName = systemName;
    }

    public boolean hasRoleForPartner(SemanticApplicationRole role, String partner) {
        if (this.hasRoleForAllPartners(role)) {
            return true;
        }
        Set<SemanticApplicationRole> partnerRoles = this.businessPartnerRoles.get(partner);
        if (partnerRoles != null) {
            return partnerRoles.stream().anyMatch(role::matches);
        }
        return false;
    }

    public boolean hasRoleForPartner(String operation, String partner) {
        SemanticApplicationRole role = new SemanticApplicationRole(this.systemName, null, null, operation);
        return this.hasRoleForPartner(role, partner);
    }

    public boolean hasRoleForPartner(String resource, String operation, String partner) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).resource(resource).operation(operation).build();
        return this.hasRoleForPartner(role, partner);
    }

    public boolean hasRoleForPartner(String tenant, String resource, String operation, String partner) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).tenant(tenant).resource(resource).operation(operation).build();
        return this.hasRoleForPartner(role, partner);
    }

    public boolean hasRole(SemanticApplicationRole role) {
        if (this.hasRoleForAllPartners(role)) {
            return true;
        }
        return this.businessPartnerRoles.values().stream().flatMap(Collection::stream).anyMatch(role::matches);
    }

    public boolean hasOperation(String operation) {
        SemanticApplicationRole role = new SemanticApplicationRole(this.systemName, null, null, operation);
        return this.hasRole(role);
    }

    public boolean hasRole(String resource, String operation) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).resource(resource).operation(operation).build();
        return this.hasRole(role);
    }

    public boolean hasRole(String tenant, String resource, String operation) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).tenant(tenant).resource(resource).operation(operation).build();
        return this.hasRole(role);
    }

    public boolean hasRoleForAllPartners(SemanticApplicationRole role) {
        return this.userRoles.stream().anyMatch(role::matches);
    }

    public boolean hasRoleForAllPartners(String operation) {
        SemanticApplicationRole role = new SemanticApplicationRole(this.systemName, null, null, operation);
        return this.hasRoleForAllPartners(role);
    }

    public boolean hasRoleForAllPartners(String resource, String operation) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).resource(resource).operation(operation).build();
        return this.hasRoleForAllPartners(role);
    }

    public boolean hasRoleForAllPartners(String tenant, String resource, String operation) {
        SemanticApplicationRole role = SemanticApplicationRole.builder().system(this.systemName).tenant(tenant).resource(resource).operation(operation).build();
        return this.hasRoleForAllPartners(role);
    }

    public Collection<SemanticApplicationRole> getAllRolesForPartner(String operation, String partner) {
        LinkedList<SemanticApplicationRole> result = new LinkedList<SemanticApplicationRole>();
        this.userRoles.stream().filter(role -> role.sameOperationOrWildcard(operation)).forEach(result::add);
        Set<SemanticApplicationRole> partnerRoles = this.businessPartnerRoles.get(partner);
        if (partnerRoles != null) {
            partnerRoles.stream().filter(role -> role.sameOperationOrWildcard(operation)).forEach(result::add);
        }
        return result;
    }

    public Collection<SemanticApplicationRole> getAllRoles(String operation) {
        LinkedList<SemanticApplicationRole> result = new LinkedList<SemanticApplicationRole>();
        this.userRoles.stream().filter(role -> role.sameOperationOrWildcard(operation)).forEach(result::add);
        this.businessPartnerRoles.values().stream().flatMap(Collection::stream).filter(role -> role.sameOperationOrWildcard(operation)).forEach(result::add);
        return result;
    }

    public Collection<SemanticApplicationRole> getAllRolesForAllPartners(String operation) {
        LinkedList<SemanticApplicationRole> result = new LinkedList<SemanticApplicationRole>();
        this.userRoles.stream().filter(role -> role.sameOperationOrWildcard(operation)).forEach(result::add);
        return result;
    }

    public Collection<String> getPartnersForRole(SemanticApplicationRole role) {
        return this.getPartnersForRole(role::matches);
    }

    public Collection<String> getPartnersForRole(String operation) {
        return this.getPartnersForRole(new SemanticApplicationRole(this.systemName, null, null, operation));
    }

    public Collection<String> getPartnersForRole(String resource, String operation) {
        return this.getPartnersForRole(SemanticApplicationRole.builder().system(this.systemName).resource(resource).operation(operation).build());
    }

    public Collection<String> getPartnersForRole(String tenant, String resource, String operation) {
        return this.getPartnersForRole(SemanticApplicationRole.builder().system(this.systemName).tenant(tenant).resource(resource).operation(operation).build());
    }

    public Collection<String> getPartnersForRole(Predicate<SemanticApplicationRole> rolePredicate) {
        return this.businessPartnerRoles.entrySet().stream().filter(entry -> ((Set)entry.getValue()).stream().anyMatch(rolePredicate)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Generated
    public Map<String, Set<SemanticApplicationRole>> getBusinessPartnerRoles() {
        return this.businessPartnerRoles;
    }

    @Generated
    public Set<SemanticApplicationRole> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticRoleRepository)) {
            return false;
        }
        SemanticRoleRepository other = (SemanticRoleRepository)o;
        Map<String, Set<SemanticApplicationRole>> this$businessPartnerRoles = this.getBusinessPartnerRoles();
        Map<String, Set<SemanticApplicationRole>> other$businessPartnerRoles = other.getBusinessPartnerRoles();
        if (this$businessPartnerRoles == null ? other$businessPartnerRoles != null : !((Object)this$businessPartnerRoles).equals(other$businessPartnerRoles)) {
            return false;
        }
        Set<SemanticApplicationRole> this$userRoles = this.getUserRoles();
        Set<SemanticApplicationRole> other$userRoles = other.getUserRoles();
        if (this$userRoles == null ? other$userRoles != null : !((Object)this$userRoles).equals(other$userRoles)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        return !(this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Set<SemanticApplicationRole>> $businessPartnerRoles = this.getBusinessPartnerRoles();
        result = result * 59 + ($businessPartnerRoles == null ? 43 : ((Object)$businessPartnerRoles).hashCode());
        Set<SemanticApplicationRole> $userRoles = this.getUserRoles();
        result = result * 59 + ($userRoles == null ? 43 : ((Object)$userRoles).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SemanticRoleRepository(businessPartnerRoles=" + String.valueOf(this.getBusinessPartnerRoles()) + ", userRoles=" + String.valueOf(this.getUserRoles()) + ", systemName=" + this.getSystemName() + ")";
    }
}

