/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionException;
import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionInvalidTokenException;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospector;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;

class JeapJwtIntrospector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapJwtIntrospector.class);
    private final Map<String, JeapTokenIntrospector> issuerTokenIntrospectors = new HashMap<String, JeapTokenIntrospector>();

    JeapJwtIntrospector(Map<String, JeapTokenIntrospector> issuerTokenIntrospectors) {
        this.issuerTokenIntrospectors.putAll(issuerTokenIntrospectors);
    }

    Map<String, Object> introspect(Jwt jwt) throws JeapIntrospectionException, JeapIntrospectionInvalidTokenException {
        try {
            return this.getTokenIntrospector(jwt).introspect(jwt.getTokenValue());
        }
        catch (JeapIntrospectionException jie) {
            log.error("Introspection failed for a token from issuer '{}' for subject '{}'.", new Object[]{jwt.getIssuer(), jwt.getSubject(), jie});
            throw jie;
        }
        catch (Exception e) {
            String msg = "An error occurred while introspecting a token from issuer '%s' for subject '%s'.".formatted(jwt.getIssuer(), jwt.getSubject());
            log.error(msg, (Throwable)e);
            throw new JeapIntrospectionException(msg, e);
        }
    }

    private JeapTokenIntrospector getTokenIntrospector(Jwt jwt) {
        String issuer = jwt.getIssuer().toString();
        JeapTokenIntrospector tokenIntrospector = this.issuerTokenIntrospectors.get(issuer);
        if (tokenIntrospector == null) {
            throw new JeapIntrospectionException("No token introspector configured for the issuer: " + issuer);
        }
        return tokenIntrospector;
    }
}

