/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.properties;

import ch.admin.bit.jeap.security.resource.properties.AuthorizationServerConfigProperties;
import ch.admin.bit.jeap.security.resource.properties.AuthorizationServerConfiguration;
import ch.admin.bit.jeap.security.resource.properties.IntrospectionProperties;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationContext;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.Set;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;

@Validated
public class B2BGatewayConfigProperties
implements AuthorizationServerConfiguration {
    @NotBlank
    private String issuer;
    @NotBlank
    private String jwkSetUri;
    @NotEmpty
    private Set<JeapAuthenticationContext> authenticationContexts = Set.of(JeapAuthenticationContext.B2B);
    private String claimSetConverterName;
    private int jwksConnectTimeoutInMillis = 15000;
    private int jwksReadTimeoutInMillis = 15000;
    @Valid
    private IntrospectionProperties introspection;

    AuthorizationServerConfigProperties asAuthorizationServerConfigProperties() {
        AuthorizationServerConfigProperties configProperties = new AuthorizationServerConfigProperties();
        configProperties.setIssuer(this.issuer);
        configProperties.setJwkSetUri(this.jwkSetUri);
        configProperties.setAuthenticationContexts(Set.copyOf(this.authenticationContexts));
        configProperties.setClaimSetConverterName(this.claimSetConverterName);
        configProperties.setIntrospection(this.introspection);
        return configProperties;
    }

    @Generated
    public B2BGatewayConfigProperties() {
    }

    @Override
    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @Generated
    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    @Override
    @Generated
    public Set<JeapAuthenticationContext> getAuthenticationContexts() {
        return this.authenticationContexts;
    }

    @Override
    @Generated
    public String getClaimSetConverterName() {
        return this.claimSetConverterName;
    }

    @Override
    @Generated
    public int getJwksConnectTimeoutInMillis() {
        return this.jwksConnectTimeoutInMillis;
    }

    @Override
    @Generated
    public int getJwksReadTimeoutInMillis() {
        return this.jwksReadTimeoutInMillis;
    }

    @Override
    @Generated
    public IntrospectionProperties getIntrospection() {
        return this.introspection;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    @Generated
    public void setAuthenticationContexts(Set<JeapAuthenticationContext> authenticationContexts) {
        this.authenticationContexts = authenticationContexts;
    }

    @Generated
    public void setClaimSetConverterName(String claimSetConverterName) {
        this.claimSetConverterName = claimSetConverterName;
    }

    @Generated
    public void setJwksConnectTimeoutInMillis(int jwksConnectTimeoutInMillis) {
        this.jwksConnectTimeoutInMillis = jwksConnectTimeoutInMillis;
    }

    @Generated
    public void setJwksReadTimeoutInMillis(int jwksReadTimeoutInMillis) {
        this.jwksReadTimeoutInMillis = jwksReadTimeoutInMillis;
    }

    @Generated
    public void setIntrospection(IntrospectionProperties introspection) {
        this.introspection = introspection;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof B2BGatewayConfigProperties)) {
            return false;
        }
        B2BGatewayConfigProperties other = (B2BGatewayConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJwksConnectTimeoutInMillis() != other.getJwksConnectTimeoutInMillis()) {
            return false;
        }
        if (this.getJwksReadTimeoutInMillis() != other.getJwksReadTimeoutInMillis()) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$jwkSetUri = this.getJwkSetUri();
        String other$jwkSetUri = other.getJwkSetUri();
        if (this$jwkSetUri == null ? other$jwkSetUri != null : !this$jwkSetUri.equals(other$jwkSetUri)) {
            return false;
        }
        Set<JeapAuthenticationContext> this$authenticationContexts = this.getAuthenticationContexts();
        Set<JeapAuthenticationContext> other$authenticationContexts = other.getAuthenticationContexts();
        if (this$authenticationContexts == null ? other$authenticationContexts != null : !((Object)this$authenticationContexts).equals(other$authenticationContexts)) {
            return false;
        }
        String this$claimSetConverterName = this.getClaimSetConverterName();
        String other$claimSetConverterName = other.getClaimSetConverterName();
        if (this$claimSetConverterName == null ? other$claimSetConverterName != null : !this$claimSetConverterName.equals(other$claimSetConverterName)) {
            return false;
        }
        IntrospectionProperties this$introspection = this.getIntrospection();
        IntrospectionProperties other$introspection = other.getIntrospection();
        return !(this$introspection == null ? other$introspection != null : !((Object)this$introspection).equals(other$introspection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof B2BGatewayConfigProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJwksConnectTimeoutInMillis();
        result = result * 59 + this.getJwksReadTimeoutInMillis();
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $jwkSetUri = this.getJwkSetUri();
        result = result * 59 + ($jwkSetUri == null ? 43 : $jwkSetUri.hashCode());
        Set<JeapAuthenticationContext> $authenticationContexts = this.getAuthenticationContexts();
        result = result * 59 + ($authenticationContexts == null ? 43 : ((Object)$authenticationContexts).hashCode());
        String $claimSetConverterName = this.getClaimSetConverterName();
        result = result * 59 + ($claimSetConverterName == null ? 43 : $claimSetConverterName.hashCode());
        IntrospectionProperties $introspection = this.getIntrospection();
        result = result * 59 + ($introspection == null ? 43 : ((Object)$introspection).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "B2BGatewayConfigProperties(issuer=" + this.getIssuer() + ", jwkSetUri=" + this.getJwkSetUri() + ", authenticationContexts=" + String.valueOf(this.getAuthenticationContexts()) + ", claimSetConverterName=" + this.getClaimSetConverterName() + ", jwksConnectTimeoutInMillis=" + this.getJwksConnectTimeoutInMillis() + ", jwksReadTimeoutInMillis=" + this.getJwksReadTimeoutInMillis() + ", introspection=" + String.valueOf(this.getIntrospection()) + ")";
    }
}

