/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.properties;

import jakarta.validation.constraints.NotEmpty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class IntrospectionProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntrospectionProperties.class);
    private static final String INTROSPECTION_URL_SUFFIX = "protocol/openid-connect/token/introspect";
    String uri;
    @NotEmpty
    String clientId;
    @NotEmpty
    String clientSecret;
    int connectTimeoutInMillis = 15000;
    int readTimeoutInMillis = 15000;

    public void validate(String issuerUri) {
        log.info("Validating introspection properties for uri {} and clientId {}", (Object)this.uri, (Object)this.clientId);
        if (this.uri == null || this.uri.isEmpty()) {
            this.uri = this.ensureTrailingSlash(issuerUri) + INTROSPECTION_URL_SUFFIX;
            log.info("No token introspection URI specified for issuer '{}'. Using issuer uri to derive the introspection uri '{}'", (Object)issuerUri, (Object)this.uri);
        }
    }

    private String ensureTrailingSlash(String uri) {
        if (!uri.endsWith("/")) {
            return uri + "/";
        }
        return uri;
    }

    @Generated
    public IntrospectionProperties() {
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public int getConnectTimeoutInMillis() {
        return this.connectTimeoutInMillis;
    }

    @Generated
    public int getReadTimeoutInMillis() {
        return this.readTimeoutInMillis;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setConnectTimeoutInMillis(int connectTimeoutInMillis) {
        this.connectTimeoutInMillis = connectTimeoutInMillis;
    }

    @Generated
    public void setReadTimeoutInMillis(int readTimeoutInMillis) {
        this.readTimeoutInMillis = readTimeoutInMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntrospectionProperties)) {
            return false;
        }
        IntrospectionProperties other = (IntrospectionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeoutInMillis() != other.getConnectTimeoutInMillis()) {
            return false;
        }
        if (this.getReadTimeoutInMillis() != other.getReadTimeoutInMillis()) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        return !(this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntrospectionProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeoutInMillis();
        result = result * 59 + this.getReadTimeoutInMillis();
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntrospectionProperties(uri=" + this.getUri() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", connectTimeoutInMillis=" + this.getConnectTimeoutInMillis() + ", readTimeoutInMillis=" + this.getReadTimeoutInMillis() + ")";
    }
}

