/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.properties;

import ch.admin.bit.jeap.security.resource.configuration.JeapOAuth2ResourceCondition;
import ch.admin.bit.jeap.security.resource.properties.AuthorizationServerConfigProperties;
import ch.admin.bit.jeap.security.resource.properties.B2BGatewayConfigProperties;
import ch.admin.bit.jeap.security.resource.properties.IntrospectionMode;
import jakarta.annotation.PostConstruct;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@AutoConfiguration
@Conditional(value={JeapOAuth2ResourceCondition.class})
@ConfigurationProperties(value="jeap.security.oauth2.resourceserver")
@Validated
public class ResourceServerProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceServerProperties.class);
    private String resourceId;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private String systemName;
    private IntrospectionMode introspectionMode;
    @NestedConfigurationProperty
    @Valid
    private AuthorizationServerConfigProperties authorizationServer;
    @NestedConfigurationProperty
    @Valid
    private B2BGatewayConfigProperties b2BGateway;
    @Valid
    List<AuthorizationServerConfigProperties> authServers;

    public String getAudience() {
        return StringUtils.hasText((String)this.resourceId) ? this.resourceId : this.applicationName;
    }

    public List<AuthorizationServerConfigProperties> getAllAuthServerConfigurations() {
        ArrayList<AuthorizationServerConfigProperties> allAuthServerConfigs = new ArrayList<AuthorizationServerConfigProperties>();
        if (this.authorizationServer != null) {
            allAuthServerConfigs.add(this.authorizationServer);
        }
        if (this.b2BGateway != null) {
            allAuthServerConfigs.add(this.b2BGateway.asAuthorizationServerConfigProperties());
        }
        if (this.authServers != null) {
            allAuthServerConfigs.addAll(this.authServers);
        }
        return allAuthServerConfigs;
    }

    @PostConstruct
    public void validate() {
        log.info("Validating resource server properties for resource id {}", (Object)this.resourceId);
        if (this.introspectionMode == null) {
            for (AuthorizationServerConfigProperties config : this.getAllAuthServerConfigurations()) {
                if (config.getIntrospection() == null) continue;
                throw new IllegalArgumentException(config.getIssuer() + ": introspection has not been activated but introspection configurations have been provided. Did you forget to activate introspection by setting an introspection mode?");
            }
        } else if (IntrospectionMode.NONE.equals((Object)this.introspectionMode)) {
            for (AuthorizationServerConfigProperties config : this.getAllAuthServerConfigurations()) {
                if (config.getIntrospection() == null) continue;
                log.warn("{}: introspection disabled with introspection mode \"NONE\", but introspection configurations provided.", (Object)config.getIssuer());
            }
        } else {
            for (AuthorizationServerConfigProperties config : this.getAllAuthServerConfigurations()) {
                if (config.getIntrospection() == null) {
                    throw new IllegalArgumentException(config.getIssuer() + ": introspection configuration must be defined when introspection mode is activated.");
                }
                config.getIntrospection().validate(config.getIssuer());
            }
        }
    }

    @Generated
    public ResourceServerProperties() {
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public IntrospectionMode getIntrospectionMode() {
        return this.introspectionMode;
    }

    @Generated
    public AuthorizationServerConfigProperties getAuthorizationServer() {
        return this.authorizationServer;
    }

    @Generated
    public B2BGatewayConfigProperties getB2BGateway() {
        return this.b2BGateway;
    }

    @Generated
    public List<AuthorizationServerConfigProperties> getAuthServers() {
        return this.authServers;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public void setIntrospectionMode(IntrospectionMode introspectionMode) {
        this.introspectionMode = introspectionMode;
    }

    @Generated
    public void setAuthorizationServer(AuthorizationServerConfigProperties authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    @Generated
    public void setB2BGateway(B2BGatewayConfigProperties b2BGateway) {
        this.b2BGateway = b2BGateway;
    }

    @Generated
    public void setAuthServers(List<AuthorizationServerConfigProperties> authServers) {
        this.authServers = authServers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceServerProperties)) {
            return false;
        }
        ResourceServerProperties other = (ResourceServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        IntrospectionMode this$introspectionMode = this.getIntrospectionMode();
        IntrospectionMode other$introspectionMode = other.getIntrospectionMode();
        if (this$introspectionMode == null ? other$introspectionMode != null : !((Object)((Object)this$introspectionMode)).equals((Object)other$introspectionMode)) {
            return false;
        }
        AuthorizationServerConfigProperties this$authorizationServer = this.getAuthorizationServer();
        AuthorizationServerConfigProperties other$authorizationServer = other.getAuthorizationServer();
        if (this$authorizationServer == null ? other$authorizationServer != null : !((Object)this$authorizationServer).equals(other$authorizationServer)) {
            return false;
        }
        B2BGatewayConfigProperties this$b2BGateway = this.getB2BGateway();
        B2BGatewayConfigProperties other$b2BGateway = other.getB2BGateway();
        if (this$b2BGateway == null ? other$b2BGateway != null : !((Object)this$b2BGateway).equals(other$b2BGateway)) {
            return false;
        }
        List<AuthorizationServerConfigProperties> this$authServers = this.getAuthServers();
        List<AuthorizationServerConfigProperties> other$authServers = other.getAuthServers();
        return !(this$authServers == null ? other$authServers != null : !((Object)this$authServers).equals(other$authServers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceServerProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        IntrospectionMode $introspectionMode = this.getIntrospectionMode();
        result = result * 59 + ($introspectionMode == null ? 43 : ((Object)((Object)$introspectionMode)).hashCode());
        AuthorizationServerConfigProperties $authorizationServer = this.getAuthorizationServer();
        result = result * 59 + ($authorizationServer == null ? 43 : ((Object)$authorizationServer).hashCode());
        B2BGatewayConfigProperties $b2BGateway = this.getB2BGateway();
        result = result * 59 + ($b2BGateway == null ? 43 : ((Object)$b2BGateway).hashCode());
        List<AuthorizationServerConfigProperties> $authServers = this.getAuthServers();
        result = result * 59 + ($authServers == null ? 43 : ((Object)$authServers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceServerProperties(resourceId=" + this.getResourceId() + ", applicationName=" + this.getApplicationName() + ", systemName=" + this.getSystemName() + ", introspectionMode=" + String.valueOf((Object)this.getIntrospectionMode()) + ", authorizationServer=" + String.valueOf(this.getAuthorizationServer()) + ", b2BGateway=" + String.valueOf(this.getB2BGateway()) + ", authServers=" + String.valueOf(this.getAuthServers()) + ")";
    }
}

