/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospection;
import ch.admin.bit.jeap.security.resource.properties.AuthorizationServerConfiguration;
import ch.admin.bit.jeap.security.resource.properties.ResourceServerProperties;
import ch.admin.bit.jeap.security.resource.validation.AudienceJwtValidator;
import ch.admin.bit.jeap.security.resource.validation.ContextIssuerJwtValidator;
import ch.admin.bit.jeap.security.resource.validation.IntrospectingJwtDecoder;
import ch.admin.bit.jeap.security.resource.validation.IssuerJwtDecoder;
import ch.admin.bit.jeap.security.resource.validation.ReactiveIssuerJwtDecoder;
import io.netty.channel.ChannelOption;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

public class JeapJwtDecoderFactory {
    private final ApplicationContext applicationContext;
    private final ResourceServerProperties resourceServerProperties;
    private final JeapJwtIntrospection jeapJwtIntrospection;

    public JwtDecoder createJwtDecoder() {
        IssuerJwtDecoder.IssuerJwtDecoderBuilder issuerJwtDecoderBuilder = IssuerJwtDecoder.builder();
        DecoderCreator<JwtDecoder> decoderCreator = DecoderCreator::createServletDecoder;
        this.resourceServerProperties.getAllAuthServerConfigurations().forEach(authConfig -> {
            JwtDecoder decoder = (JwtDecoder)this.createDecoder((AuthorizationServerConfiguration)authConfig, this.resourceServerProperties.getAudience(), decoderCreator);
            issuerJwtDecoderBuilder.issuerDecoder(authConfig.getIssuer(), decoder);
        });
        IssuerJwtDecoder issuerJwtDecoder = issuerJwtDecoderBuilder.build();
        return this.addIntrospectionIfConfigured(issuerJwtDecoder);
    }

    public ReactiveJwtDecoder createReactiveJwtDecoder() {
        ReactiveIssuerJwtDecoder.ReactiveIssuerJwtDecoderBuilder issuerJwtDecoderBuilder = ReactiveIssuerJwtDecoder.builder();
        DecoderCreator<ReactiveJwtDecoder> decoderCreator = DecoderCreator::createReactiveDecoder;
        this.resourceServerProperties.getAllAuthServerConfigurations().forEach(authConfig -> {
            ReactiveJwtDecoder decoder = (ReactiveJwtDecoder)this.createDecoder((AuthorizationServerConfiguration)authConfig, this.resourceServerProperties.getAudience(), decoderCreator);
            issuerJwtDecoderBuilder.issuerDecoder(authConfig.getIssuer(), decoder);
        });
        return issuerJwtDecoderBuilder.build();
    }

    private <T> T createDecoder(AuthorizationServerConfiguration authServerConfig, String audience, DecoderCreator<T> creator) {
        JwtTimestampValidator timestampValidator = new JwtTimestampValidator(Duration.ofSeconds(30L));
        AudienceJwtValidator audienceValidator = new AudienceJwtValidator(audience);
        String issuer = authServerConfig.getIssuer();
        ContextIssuerJwtValidator issuerValidator = new ContextIssuerJwtValidator(authServerConfig.getAuthenticationContexts(), issuer);
        DelegatingOAuth2TokenValidator jwtValidator = new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{timestampValidator, audienceValidator, issuerValidator});
        String jwkSetUri = authServerConfig.getJwkSetUri();
        Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = this.lookupClaimSetConverter(authServerConfig);
        return creator.create(jwkSetUri, (OAuth2TokenValidator<Jwt>)jwtValidator, claimSetConverter, new JwksTimeoutConfiguration(authServerConfig.getJwksConnectTimeoutInMillis(), authServerConfig.getJwksReadTimeoutInMillis()));
    }

    private Converter<Map<String, Object>, Map<String, Object>> lookupClaimSetConverter(AuthorizationServerConfiguration authServerConfig) {
        String claimSetConverterName = authServerConfig.getClaimSetConverterName();
        if (StringUtils.hasText((String)claimSetConverterName)) {
            try {
                Object bean = this.applicationContext.getBean(claimSetConverterName);
                return (Converter)bean;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No claim set converter bean with name " + claimSetConverterName + " found in application context.", e);
            }
        }
        return MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    }

    private JwtDecoder addIntrospectionIfConfigured(JwtDecoder jwtDecoder) {
        if (this.jeapJwtIntrospection != null) {
            return new IntrospectingJwtDecoder(jwtDecoder, this.jeapJwtIntrospection);
        }
        return jwtDecoder;
    }

    @Generated
    public JeapJwtDecoderFactory(ApplicationContext applicationContext, ResourceServerProperties resourceServerProperties, JeapJwtIntrospection jeapJwtIntrospection) {
        this.applicationContext = applicationContext;
        this.resourceServerProperties = resourceServerProperties;
        this.jeapJwtIntrospection = jeapJwtIntrospection;
    }

    static interface DecoderCreator<T> {
        public T create(String var1, OAuth2TokenValidator<Jwt> var2, Converter<Map<String, Object>, Map<String, Object>> var3, JwksTimeoutConfiguration var4);

        public static JwtDecoder createServletDecoder(String jwkSetUri, OAuth2TokenValidator<Jwt> jwtValidator, Converter<Map<String, Object>, Map<String, Object>> claimSetConverter, JwksTimeoutConfiguration jwksTimeoutConfiguration) {
            NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SignatureAlgorithm.RS256).jwsAlgorithm(SignatureAlgorithm.RS512).restOperations((RestOperations)DecoderCreator.createRestTemplate(jwksTimeoutConfiguration)).build();
            jwtDecoder.setJwtValidator(jwtValidator);
            jwtDecoder.setClaimSetConverter(claimSetConverter);
            return jwtDecoder;
        }

        public static ReactiveJwtDecoder createReactiveDecoder(String jwkSetUri, OAuth2TokenValidator<Jwt> jwtValidator, Converter<Map<String, Object>, Map<String, Object>> claimSetConverter, JwksTimeoutConfiguration jwksTimeoutConfiguration) {
            NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SignatureAlgorithm.RS256).jwsAlgorithm(SignatureAlgorithm.RS512).webClient(DecoderCreator.createWebClient(jwksTimeoutConfiguration)).build();
            jwtDecoder.setJwtValidator(jwtValidator);
            jwtDecoder.setClaimSetConverter(claimSetConverter);
            return jwtDecoder;
        }

        private static RestTemplate createRestTemplate(JwksTimeoutConfiguration jwksTimeoutConfiguration) {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(jwksTimeoutConfiguration.connectTimeoutInMillis());
            requestFactory.setReadTimeout(jwksTimeoutConfiguration.readTimeoutInMillis());
            return new RestTemplate((ClientHttpRequestFactory)requestFactory);
        }

        private static WebClient createWebClient(JwksTimeoutConfiguration jwksTimeoutConfiguration) {
            HttpClient httpClient = (HttpClient)HttpClient.create().responseTimeout(Duration.ofMillis(jwksTimeoutConfiguration.readTimeoutInMillis())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)jwksTimeoutConfiguration.connectTimeoutInMillis());
            return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        }
    }

    record JwksTimeoutConfiguration(int connectTimeoutInMillis, int readTimeoutInMillis) {
    }
}

