/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospectionCondition;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.security.oauth2.jwt.Jwt;

public class LightweightTokenIntrospectionCondition
implements JeapJwtIntrospectionCondition {
    static final String ROLES_PRUNED_CHARS_CLAIM = "roles_pruned_chars";
    static final String LIGHTWEIGHT_SCOPE_NAME = "lightweight";
    private static final Pattern LIGHTWEIGHT_SCOPE_PATTERN = Pattern.compile("\\blightweight\\b");

    @Override
    public boolean needsIntrospection(Jwt jwt) {
        Map claims = jwt.getClaims();
        if (claims.containsKey(ROLES_PRUNED_CHARS_CLAIM)) {
            return true;
        }
        Object scopeObject = claims.get("scope");
        if (scopeObject instanceof String) {
            String scope = (String)scopeObject;
            return LIGHTWEIGHT_SCOPE_PATTERN.matcher(scope).find();
        }
        if (scopeObject instanceof String[]) {
            String[] scopes = (String[])scopeObject;
            return Arrays.asList(scopes).contains(LIGHTWEIGHT_SCOPE_NAME);
        }
        return false;
    }
}

