/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.AlwaysTokenIntrospectionCondition;
import ch.admin.bit.jeap.security.resource.introspection.DefaultJeapTokenIntrospectorFactory;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospection;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospectionCondition;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospector;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospectionEnabled;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospector;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospectorConfiguration;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospectorFactory;
import ch.admin.bit.jeap.security.resource.introspection.LightweightTokenIntrospectionCondition;
import ch.admin.bit.jeap.security.resource.introspection.NeverTokenIntrospectionCondition;
import ch.admin.bit.jeap.security.resource.properties.AuthorizationServerConfiguration;
import ch.admin.bit.jeap.security.resource.properties.IntrospectionMode;
import ch.admin.bit.jeap.security.resource.properties.IntrospectionProperties;
import ch.admin.bit.jeap.security.resource.properties.ResourceServerProperties;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration
@Conditional(value={JeapTokenIntrospectionEnabled.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class MvcJeapIntrospectionConfiguration {
    MvcJeapIntrospectionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={JeapTokenIntrospectorFactory.class})
    JeapTokenIntrospectorFactory jeapTokenIntrospectorFactory() {
        return new DefaultJeapTokenIntrospectorFactory();
    }

    @Bean
    JeapJwtIntrospector jeapJwtIntrospector(JeapTokenIntrospectorFactory factory, ResourceServerProperties resourceServerProperties) {
        Map<String, JeapTokenIntrospector> issuerTokenIntrospectors = resourceServerProperties.getAllAuthServerConfigurations().stream().filter(authServerConfig -> authServerConfig.getIntrospection() != null && authServerConfig.getIntrospection().getMode() != IntrospectionMode.NONE).map(this::toJeapTokenIntrospectorConfiguration).collect(Collectors.toMap(JeapTokenIntrospectorConfiguration::issuer, factory::create));
        return new JeapJwtIntrospector(issuerTokenIntrospectors);
    }

    @Bean
    @ConditionalOnExpression(value="!'CUSTOM'.equalsIgnoreCase('${jeap.security.resourceserver.introspection.mode:}')")
    JeapJwtIntrospectionCondition jeapJwtIntrospectionCondition(ResourceServerProperties resourceServerProperties) {
        return switch (resourceServerProperties.getIntrospection().getMode()) {
            case IntrospectionMode.ALWAYS -> new AlwaysTokenIntrospectionCondition();
            case IntrospectionMode.LIGHTWEIGHT -> new LightweightTokenIntrospectionCondition();
            default -> new NeverTokenIntrospectionCondition();
        };
    }

    @Bean
    JeapJwtIntrospection jeapJwtIntrospection(JeapJwtIntrospector jwtIntrospector, JeapJwtIntrospectionCondition introspectionCondition) {
        return new JeapJwtIntrospection(jwtIntrospector, introspectionCondition);
    }

    private JeapTokenIntrospectorConfiguration toJeapTokenIntrospectorConfiguration(AuthorizationServerConfiguration authorizationServerConfiguration) {
        IntrospectionProperties introspectionProperties = authorizationServerConfiguration.getIntrospection();
        return new JeapTokenIntrospectorConfiguration(authorizationServerConfiguration.getIssuer(), introspectionProperties.getUri(), introspectionProperties.getClientId(), introspectionProperties.getClientSecret(), Duration.ofMillis(introspectionProperties.getConnectTimeoutInMillis()), Duration.ofMillis(introspectionProperties.getReadTimeoutInMillis()));
    }
}

