/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.configuration;

import ch.admin.bit.jeap.security.resource.authentication.SimpleRoleRepository;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;

public class SimpleMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        if (authentication instanceof JeapAuthenticationToken) {
            JeapAuthenticationToken jeapAuth = (JeapAuthenticationToken)authentication;
            SimpleMethodSecurityExpressionRoot root = new SimpleMethodSecurityExpressionRoot(jeapAuth);
            root.setThis(invocation.getThis());
            root.setPermissionEvaluator(this.getPermissionEvaluator());
            root.setTrustResolver(this.getTrustResolver());
            root.setRoleHierarchy(this.getRoleHierarchy());
            root.setDefaultRolePrefix(this.getDefaultRolePrefix());
            return root;
        }
        return super.createSecurityExpressionRoot(authentication, invocation);
    }

    public EvaluationContext createEvaluationContext(Supplier<Authentication> authentication, MethodInvocation mi) {
        StandardEvaluationContext context = (StandardEvaluationContext)super.createEvaluationContext(authentication, mi);
        Authentication authentication2 = authentication.get();
        if (authentication2 instanceof JeapAuthenticationToken) {
            JeapAuthenticationToken jeapAuthenticationToken = (JeapAuthenticationToken)authentication2;
            SimpleMethodSecurityExpressionRoot root = new SimpleMethodSecurityExpressionRoot(jeapAuthenticationToken);
            root.setThis(mi.getThis());
            root.setPermissionEvaluator(this.getPermissionEvaluator());
            root.setTrustResolver(this.getTrustResolver());
            root.setRoleHierarchy(this.getRoleHierarchy());
            root.setDefaultRolePrefix(this.getDefaultRolePrefix());
            context.setRootObject((Object)root);
        }
        return context;
    }

    private static class SimpleMethodSecurityExpressionRoot
    extends SecurityExpressionRoot
    implements MethodSecurityExpressionOperations {
        private final SimpleRoleRepository simpleRoleRepository;
        private Object filterObject;
        private Object returnObject;
        private Object target;

        private SimpleMethodSecurityExpressionRoot(JeapAuthenticationToken jeapAuth) {
            super((Authentication)jeapAuth);
            this.simpleRoleRepository = new SimpleRoleRepository(jeapAuth.getUserRoles(), jeapAuth.getBusinessPartnerRoles());
        }

        public Object getThis() {
            return this.target;
        }

        private void setThis(Object target) {
            this.target = target;
        }

        @Generated
        public Object getFilterObject() {
            return this.filterObject;
        }

        @Generated
        public void setFilterObject(Object filterObject) {
            this.filterObject = filterObject;
        }

        @Generated
        public Object getReturnObject() {
            return this.returnObject;
        }

        @Generated
        public void setReturnObject(Object returnObject) {
            this.returnObject = returnObject;
        }

        @Generated
        public boolean hasRoleForPartner(String role, String businessPartner) {
            return this.simpleRoleRepository.hasRoleForPartner(role, businessPartner);
        }

        @Generated
        public boolean hasRoleForAllPartners(String role) {
            return this.simpleRoleRepository.hasRoleForAllPartners(role);
        }

        @Generated
        public Set<String> getPartnersForRole(String role) {
            return this.simpleRoleRepository.getPartnersForRole(role);
        }
    }

    private static interface SimpleAuthenticationExpressionRootMethods {
        public boolean hasRoleForPartner(String var1, String var2);

        public boolean hasRoleForAllPartners(String var1);

        public Set<String> getPartnersForRole(String var1);
    }
}

