/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionException;
import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionInvalidTokenException;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospectionCondition;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospector;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospectionMetrics;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;

public class JeapJwtIntrospection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapJwtIntrospection.class);
    private final JeapJwtIntrospector jwtIntrospector;
    private final JeapJwtIntrospectionCondition introspectionCondition;
    private final Optional<JeapTokenIntrospectionMetrics> jeapTokenIntrospectionMetrics;

    public Jwt introspectIfNeeded(Jwt jwt) throws JeapIntrospectionInvalidTokenException, JeapIntrospectionException {
        if (this.introspectionCondition.needsIntrospection(jwt)) {
            try {
                Jwt enrichedJwt = this.introspectAndEnrich(jwt);
                this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordConditionalTokenIntrospection(jwt, true, true));
                return enrichedJwt;
            }
            catch (JeapIntrospectionInvalidTokenException e) {
                this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordConditionalTokenIntrospection(jwt, true, false));
                throw e;
            }
            catch (Exception e) {
                this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordConditionalTokenIntrospection(jwt, true, null));
                throw e;
            }
        }
        this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordConditionalTokenIntrospection(jwt, false, null));
        return jwt;
    }

    public boolean isValid(Jwt jwt) {
        try {
            this.jwtIntrospector.introspect(jwt);
            this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordValidityCheck(jwt, true));
            return true;
        }
        catch (JeapIntrospectionInvalidTokenException e) {
            log.error("Introspection found an invalid token from issuer '{}' for subject '{}'.", new Object[]{jwt.getIssuer(), jwt.getSubject(), e});
            this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordValidityCheck(jwt, false));
            return false;
        }
        catch (Exception e) {
            log.error("Declaring a token from issuer '{}' for subject '{}' to be invalid as its introspection failed.", new Object[]{jwt.getIssuer(), jwt.getSubject(), e});
            this.jeapTokenIntrospectionMetrics.ifPresent(metrics -> metrics.recordValidityCheck(jwt, false));
            return false;
        }
    }

    private Jwt introspectAndEnrich(Jwt jwt) {
        Map<String, Object> introspectionAttributes = this.jwtIntrospector.introspect(jwt);
        HashMap jwtClaims = new HashMap(jwt.getClaims());
        introspectionAttributes.forEach((attribute, value) -> jwtClaims.computeIfAbsent(attribute, k -> value));
        return new Jwt(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getHeaders(), jwtClaims);
    }

    @Generated
    public JeapJwtIntrospection(JeapJwtIntrospector jwtIntrospector, JeapJwtIntrospectionCondition introspectionCondition, Optional<JeapTokenIntrospectionMetrics> jeapTokenIntrospectionMetrics) {
        this.jwtIntrospector = jwtIntrospector;
        this.introspectionCondition = introspectionCondition;
        this.jeapTokenIntrospectionMetrics = jeapTokenIntrospectionMetrics;
    }
}

