/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.log;

import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserAccessLoggingRequestFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAccessLoggingRequestFilter.class);
    private static final Set<String> BLACKLISTED_PATHS = Set.of("/actuator", "/api-docs", "/swagger-ui", "/ui/configuration");

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String url = Optional.ofNullable(request.getQueryString()).map(request.getRequestURL().append('?')::append).orElseGet(() -> ((HttpServletRequest)request).getRequestURL()).toString();
        if (request.getUserPrincipal() instanceof JeapAuthenticationToken) {
            JeapAuthenticationToken principal = (JeapAuthenticationToken)((Object)request.getUserPrincipal());
            log.info("{} ({}) authenticated for {} {}", new Object[]{StructuredArguments.keyValue((String)"username", (Object)principal.getTokenName()), StructuredArguments.keyValue((String)"extId", (Object)((Jwt)principal.getToken()).getClaimAsString("ext_id")), request.getMethod(), url});
        } else {
            log.info("{} authenticated for {} {}", new Object[]{StructuredArguments.keyValue((String)"username", (Object)request.getUserPrincipal().getName()), request.getMethod(), url});
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return BLACKLISTED_PATHS.stream().anyMatch(request.getRequestURI()::contains) || request.getUserPrincipal() == null;
    }
}

