/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionException;
import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionInvalidTokenException;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospection;
import ch.admin.bit.jeap.security.resource.validation.JeapExternalTokenValidationException;
import ch.admin.bit.jeap.security.resource.validation.JeapTokenValidationException;
import lombok.Generated;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

class IntrospectingJwtDecoder
implements JwtDecoder {
    private final JwtDecoder jwtDecoderDelegate;
    private final JeapJwtIntrospection jeapJwtIntrospection;

    public Jwt decode(String token) {
        try {
            return this.jeapJwtIntrospection.introspectIfNeeded(this.jwtDecoderDelegate.decode(token));
        }
        catch (JeapIntrospectionInvalidTokenException inactiveException) {
            throw new JeapTokenValidationException("Token invalid according to its introspection.", inactiveException);
        }
        catch (JeapIntrospectionException introspectionException) {
            throw new JeapExternalTokenValidationException("Token introspection on auth server failed.", introspectionException);
        }
    }

    @Generated
    public IntrospectingJwtDecoder(JwtDecoder jwtDecoderDelegate, JeapJwtIntrospection jeapJwtIntrospection) {
        this.jwtDecoderDelegate = jwtDecoderDelegate;
        this.jeapJwtIntrospection = jeapJwtIntrospection;
    }
}

