/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class SimpleRoleRepository {
    private final Set<String> userRoles;
    private final Map<String, Set<String>> businessPartnerRoles;

    public SimpleRoleRepository(Set<String> userRoles, Map<String, Set<String>> businessPartnerRoles) {
        this.userRoles = Set.copyOf(userRoles);
        this.businessPartnerRoles = businessPartnerRoles.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> Set.copyOf((Collection)entry.getValue())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRole(String role) {
        if (this.hasRoleForAllPartners(role)) return true;
        if (!this.businessPartnerRoles.values().stream().flatMap(Collection::stream).anyMatch(role::equals)) return false;
        return true;
    }

    public boolean hasRoleForPartner(String role, String businessPartner) {
        return this.hasRoleForAllPartners(role) || this.businessPartnerRoles.getOrDefault(businessPartner, Collections.emptySet()).contains(role);
    }

    public boolean hasRoleForAllPartners(String role) {
        return this.userRoles.contains(role);
    }

    public Set<String> getPartnersForRole(String role) {
        return this.businessPartnerRoles.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(role)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Generated
    public Set<String> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public Map<String, Set<String>> getBusinessPartnerRoles() {
        return this.businessPartnerRoles;
    }
}

