/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.token;

import ch.admin.bit.jeap.security.resource.token.AuthoritiesResolver;
import ch.admin.bit.jeap.security.resource.token.DefaultAuthoritiesResolver;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

public class JeapAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapAuthenticationConverter.class);
    private static final String USER_ROLES_CLAIM = "userroles";
    private static final String BUSINESS_PARTNER_ROLES_CLAIM = "bproles";
    private final AuthoritiesResolver authoritiesResolver;

    public JeapAuthenticationConverter() {
        this(new DefaultAuthoritiesResolver());
    }

    public AbstractAuthenticationToken convert(@NonNull Jwt jwt) {
        Set<String> userRoles = this.extractUserRoles(jwt);
        Map<String, Set<String>> businessPartnerRoles = this.extractBusinessPartnerRoles(jwt);
        Collection<GrantedAuthority> grantedAuthorities = this.authoritiesResolver.deriveAuthoritiesFromRoles(userRoles, businessPartnerRoles);
        return new JeapAuthenticationToken(jwt, userRoles, businessPartnerRoles, grantedAuthorities);
    }

    private Set<String> extractUserRoles(Jwt jwt) {
        List userRolesClaim = Optional.of(jwt).map(Jwt::getClaims).map(map -> map.get(USER_ROLES_CLAIM)).flatMap(this::castUserRoles).orElse(Collections.emptyList());
        return Set.copyOf(userRolesClaim);
    }

    private Map<String, Set<String>> extractBusinessPartnerRoles(Jwt jwt) {
        return this.extractBusinesspartnerRolesClaim(jwt).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Set.copyOf((Collection)entry.getValue())));
    }

    private Map<String, List<String>> extractBusinesspartnerRolesClaim(Jwt jwt) {
        return Optional.of(jwt).map(Jwt::getClaims).map(map -> map.get(BUSINESS_PARTNER_ROLES_CLAIM)).flatMap(this::castBusinessPartnerRoleMap).orElse(Collections.emptyMap());
    }

    private Optional<Map<String, List<String>>> castBusinessPartnerRoleMap(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((Map)value);
        }
        catch (ClassCastException e) {
            log.warn("Unable to cast Business Partner Role claim to Map<List<String>>, ignoring the entry.");
            return Optional.empty();
        }
    }

    private Optional<List<String>> castUserRoles(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((List)value);
        }
        catch (ClassCastException e) {
            log.warn("Unable to cast User Role claim to List<String>, ignoring the entry.");
            return Optional.empty();
        }
    }

    @Generated
    public JeapAuthenticationConverter(AuthoritiesResolver authoritiesResolver) {
        this.authoritiesResolver = authoritiesResolver;
    }
}

