/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.configuration;

import ch.admin.bit.jeap.security.resource.authentication.ServletSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.configuration.JeapMethodSecurityExpressionHandlerCustomizer;
import ch.admin.bit.jeap.security.resource.configuration.JeapOAuth2ResourceCondition;
import ch.admin.bit.jeap.security.resource.configuration.JeapOauth2ResourceAccessDeniedHandler;
import ch.admin.bit.jeap.security.resource.configuration.JeapOauth2ResourceAuthenticationEntryPoint;
import ch.admin.bit.jeap.security.resource.configuration.SemanticAuthorizationCondition;
import ch.admin.bit.jeap.security.resource.configuration.SemanticMethodSecurityExpressionHandler;
import ch.admin.bit.jeap.security.resource.configuration.SimpleMethodSecurityExpressionHandler;
import ch.admin.bit.jeap.security.resource.introspection.JeapJwtIntrospection;
import ch.admin.bit.jeap.security.resource.log.LoggingBearerTokenAccessDeniedHandler;
import ch.admin.bit.jeap.security.resource.log.LoggingBearerTokenAuthenticationEntryPoint;
import ch.admin.bit.jeap.security.resource.log.UserAccessLoggingRequestFilter;
import ch.admin.bit.jeap.security.resource.properties.ResourceServerProperties;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import ch.admin.bit.jeap.security.resource.token.AuthoritiesResolver;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationConverter;
import ch.admin.bit.jeap.security.resource.validation.JeapJwtDecoderFactory;
import jakarta.servlet.DispatcherType;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;

@AutoConfiguration
@Conditional(value={JeapOAuth2ResourceCondition.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableWebSecurity
@EnableMethodSecurity(securedEnabled=true, jsr250Enabled=true)
public class MvcSecurityConfiguration {
    private final ResourceServerProperties resourceServerProperties;
    private final ApplicationContext context;
    private final Environment environment;
    private final AuthoritiesResolver authoritiesResolver;
    private final Optional<JeapMethodSecurityExpressionHandlerCustomizer> expressionHandlerCustomizer;
    private final Optional<JeapJwtIntrospection> jeapJwtIntrospection;

    @Bean
    public MethodSecurityExpressionHandler customMethodSecurityExpressionHandler() {
        DefaultMethodSecurityExpressionHandler expressionHandler = SemanticAuthorizationCondition.isSemanticAuthorizationEnabled(this.environment) ? new SemanticMethodSecurityExpressionHandler(this.resourceServerProperties.getSystemName()) : new SimpleMethodSecurityExpressionHandler();
        expressionHandler.setApplicationContext(this.context);
        return this.customize(expressionHandler);
    }

    private MethodSecurityExpressionHandler customize(DefaultMethodSecurityExpressionHandler expressionHandler) {
        if (this.expressionHandlerCustomizer.isPresent()) {
            return this.expressionHandlerCustomizer.get().customize(expressionHandler);
        }
        return expressionHandler;
    }

    @Bean
    public JeapJwtDecoderFactory jeapJwtDecoderFactory() {
        return new JeapJwtDecoderFactory(this.context, this.resourceServerProperties, this.jeapJwtIntrospection.orElse(null));
    }

    @Bean
    public ServletSimpleAuthorization jeapSimpleAuthorization() {
        return new ServletSimpleAuthorization();
    }

    @Bean
    @Conditional(value={SemanticAuthorizationCondition.class})
    public ServletSemanticAuthorization jeapSemanticAuthorization() {
        return new ServletSemanticAuthorization(this.resourceServerProperties.getSystemName());
    }

    @ConditionalOnProperty(value={"jeap.security.oauth2.resourceserver.log.authentication-failure.enabled"})
    @ConditionalOnMissingBean(value={JeapOauth2ResourceAuthenticationEntryPoint.class})
    @Bean
    public JeapOauth2ResourceAuthenticationEntryPoint jeapOauth2ResourceAuthenticationEntryPoint() {
        return new LoggingBearerTokenAuthenticationEntryPoint();
    }

    @ConditionalOnProperty(value={"jeap.security.oauth2.resourceserver.log.access-denied.enabled"})
    @ConditionalOnMissingBean(value={JeapOauth2ResourceAccessDeniedHandler.class})
    @Bean
    public JeapOauth2ResourceAccessDeniedHandler jeapOauth2ResourceAccessDeniedHandler(@Value(value="${jeap.security.oauth2.resourceserver.log.access-denied.debug:false}") boolean debugEnabled) {
        return new LoggingBearerTokenAccessDeniedHandler(debugEnabled);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public SecurityFilterChain oauth2SecurityWebFilterChain(HttpSecurity http, JeapJwtDecoderFactory jeapJwtDecoderFactory, Optional<JeapOauth2ResourceAuthenticationEntryPoint> jeapOauth2ResourceAuthenticationEntryPoint, Optional<JeapOauth2ResourceAccessDeniedHandler> jeapOauth2ResourceAccessDeniedHandler, @Value(value="${server.error.path:${error.path:/error}}") String errorPath) throws Exception {
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(new RequestMatcher[]{RequestMatchers.allOf((RequestMatcher[])new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)errorPath), new DispatcherTypeRequestMatcher(DispatcherType.ERROR)})})).permitAll().anyRequest()).fullyAuthenticated());
        http.cors(Customizer.withDefaults());
        http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()));
        http.sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        JwtDecoder jwtDecoder = jeapJwtDecoderFactory.createJwtDecoder();
        JeapAuthenticationConverter authenticationConverter = new JeapAuthenticationConverter(this.authoritiesResolver);
        http.oauth2ResourceServer(oauth2ResourceServer -> {
            oauth2ResourceServer.jwt(jwt -> jwt.decoder(jwtDecoder).jwtAuthenticationConverter((Converter)authenticationConverter));
            jeapOauth2ResourceAuthenticationEntryPoint.ifPresent(arg_0 -> ((OAuth2ResourceServerConfigurer)oauth2ResourceServer).authenticationEntryPoint(arg_0));
            jeapOauth2ResourceAccessDeniedHandler.ifPresent(arg_0 -> ((OAuth2ResourceServerConfigurer)oauth2ResourceServer).accessDeniedHandler(arg_0));
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnProperty(name={"jeap.security.oauth2.resourceserver.log-user-access"}, havingValue="true")
    UserAccessLoggingRequestFilter userAccessLoggingRequestFilter() {
        return new UserAccessLoggingRequestFilter();
    }

    @Generated
    public MvcSecurityConfiguration(ResourceServerProperties resourceServerProperties, ApplicationContext context, Environment environment, AuthoritiesResolver authoritiesResolver, Optional<JeapMethodSecurityExpressionHandlerCustomizer> expressionHandlerCustomizer, Optional<JeapJwtIntrospection> jeapJwtIntrospection) {
        this.resourceServerProperties = resourceServerProperties;
        this.context = context;
        this.environment = environment;
        this.authoritiesResolver = authoritiesResolver;
        this.expressionHandlerCustomizer = expressionHandlerCustomizer;
        this.jeapJwtIntrospection = jeapJwtIntrospection;
    }
}

