/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.restclient;

import ch.admin.bit.jeap.security.restclient.DefaultJeapOAuth2RestClientBuilderFactory;
import ch.admin.bit.jeap.security.restclient.JeapOAuth2RestClientBuilderFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.web.client.RestClient;

@AutoConfiguration
@ConditionalOnClass(value={RestClient.class})
public class OAuth2RestClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2RestClientConfiguration.class);

    @Generated
    private OAuth2RestClientConfiguration() {
    }

    @Configuration
    @ConditionalOnMissingBean(value={JeapOAuth2RestClientBuilderFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletRestClientForNoOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2RestClientBuilderFactory jeapOAuth2RestclientBuilderFactory(RestClient.Builder builder) {
            return new DefaultJeapOAuth2RestClientBuilderFactory(builder, null, null);
        }
    }

    @Configuration
    @Order(value=0x7FFFFFFE)
    @Conditional(value={ClientsConfiguredCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletRestClientForOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2RestClientBuilderFactory jeapOAuth2RestclientBuilderFactory(RestClient.Builder builder, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
            return new DefaultJeapOAuth2RestClientBuilderFactory(builder, this.authorizedClientManager(clientRegistrationRepository, clientService), clientRegistrationRepository);
        }

        private OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
            AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, clientService);
            OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return authorizedClientManager;
        }
    }
}

