/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.client;

import ch.admin.bit.jeap.security.client.DefaultJeapOAuth2WebclientBuilderFactory;
import ch.admin.bit.jeap.security.client.JeapOAuth2WebclientBuilderFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.server.resource.web.reactive.function.client.ServerBearerExchangeFilterFunction;
import org.springframework.security.oauth2.server.resource.web.reactive.function.client.ServletBearerExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration
@ConditionalOnClass(value={WebClient.class})
public class OAuth2ClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientConfiguration.class);

    @Configuration
    @ConditionalOnMissingBean(value={JeapOAuth2WebclientBuilderFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactivetWebClientForNoOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2WebclientBuilderFactory jeapOAuth2WebclientBuilderFactory(WebClient.Builder builder) {
            return new DefaultJeapOAuth2WebclientBuilderFactory(builder, (ExchangeFilterFunction)new ServerBearerExchangeFilterFunction());
        }
    }

    @Configuration
    @Order(value=0x7FFFFFFE)
    @Conditional(value={ClientsConfiguredCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactivetWebClientForOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2WebclientBuilderFactory jeapOAuth2WebclientBuilderFactory(WebClient.Builder builder, ReactiveClientRegistrationRepository clientRegistrationRepository, ReactiveOAuth2AuthorizedClientService clientService) {
            return new DefaultJeapOAuth2WebclientBuilderFactory(builder, (ExchangeFilterFunction)new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)this.authorizedClientManager(clientRegistrationRepository, clientService)), (ExchangeFilterFunction)new ServerBearerExchangeFilterFunction(), id -> (ClientRegistration)clientRegistrationRepository.findByRegistrationId(id).block());
        }

        private AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ReactiveOAuth2AuthorizedClientService clientService) {
            AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, clientService);
            ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return authorizedClientManager;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={JeapOAuth2WebclientBuilderFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletWebClientForNoOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2WebclientBuilderFactory jeapOAuth2WebclientBuilderFactory(WebClient.Builder builder) {
            return new DefaultJeapOAuth2WebclientBuilderFactory(builder, (ExchangeFilterFunction)new ServletBearerExchangeFilterFunction());
        }
    }

    @Configuration
    @Order(value=0x7FFFFFFE)
    @Conditional(value={ClientsConfiguredCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletWebClientForOAuthClientsConfiguration {
        @Bean
        public JeapOAuth2WebclientBuilderFactory jeapOAuth2WebclientBuilderFactory(WebClient.Builder builder, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
            return new DefaultJeapOAuth2WebclientBuilderFactory(builder, (ExchangeFilterFunction)new ServletOAuth2AuthorizedClientExchangeFilterFunction(this.authorizedClientManager(clientRegistrationRepository, clientService)), (ExchangeFilterFunction)new ServletBearerExchangeFilterFunction(), arg_0 -> ((ClientRegistrationRepository)clientRegistrationRepository).findByRegistrationId(arg_0));
        }

        private OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
            AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, clientService);
            OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return authorizedClientManager;
        }
    }
}

