/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionException;
import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionInvalidTokenException;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospector;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospectorConfiguration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestOperations;

class DelegatingToSpringJeapTokenIntrospector
implements JeapTokenIntrospector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelegatingToSpringJeapTokenIntrospector.class);
    private final SpringOpaqueTokenIntrospector tokenIntrospector;

    DelegatingToSpringJeapTokenIntrospector(JeapTokenIntrospectorConfiguration config) {
        RestOperations restOperations = this.createRestOperations(config);
        this.tokenIntrospector = new SpringOpaqueTokenIntrospector(config.introspectionUri(), restOperations);
    }

    @Override
    public Map<String, Object> introspect(String token) throws OAuth2IntrospectionException, InvalidBearerTokenException {
        try {
            OAuth2AuthenticatedPrincipal introspectionResult = this.tokenIntrospector.introspect(token);
            return introspectionResult.getAttributes();
        }
        catch (BadOpaqueTokenException bte) {
            throw new JeapIntrospectionInvalidTokenException(bte);
        }
        catch (OAuth2IntrospectionException oie) {
            Throwable oieCause = oie.getCause();
            if (oieCause instanceof ResourceAccessException) {
                throw new JeapIntrospectionException("Accessing token introspection endpoint failed.", oie);
            }
            throw new JeapIntrospectionException("Token introspection failed: " + oie.getMessage(), oie);
        }
        catch (Exception e) {
            throw new JeapIntrospectionException("Token introspection failed: " + e.getMessage(), e);
        }
    }

    private RestOperations createRestOperations(JeapTokenIntrospectorConfiguration config) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return restTemplateBuilder.connectTimeout(config.connectTimeout()).readTimeout(config.readTimeout()).interceptors(new ClientHttpRequestInterceptor[]{new BasicAuthenticationInterceptor(config.clientId(), config.clientSecret())}).build();
    }
}

