/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.validation.JeapTokenValidationException;
import ch.admin.bit.jeap.security.resource.validation.RawJwtTokenParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import reactor.core.publisher.Mono;

class ReactiveIssuerJwtDecoder
implements ReactiveJwtDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveIssuerJwtDecoder.class);
    private final Map<String, ReactiveJwtDecoder> issuerDecoderMap;

    private ReactiveIssuerJwtDecoder(Map<String, ReactiveJwtDecoder> issuerDecoderMap) {
        if (issuerDecoderMap.isEmpty()) {
            throw new IllegalStateException("At least one decoder must be configured.");
        }
        this.issuerDecoderMap = issuerDecoderMap;
    }

    public Mono<Jwt> decode(String token) throws JwtException {
        String issuer = this.extractIssuer(token);
        ReactiveJwtDecoder decoder = this.issuerDecoderMap.get(issuer);
        if (decoder != null) {
            log.debug("Decoding a token from issuer '{}' ", (Object)issuer);
            return decoder.decode(token).doOnNext(jwt -> log.debug("Decoded token from issuer '{}' for subject '{}'.", (Object)jwt.getIssuer(), (Object)jwt.getSubject()));
        }
        throw new JeapTokenValidationException("Unsupported issuer '" + issuer + "'. There is no JwtDecoder configured for it.");
    }

    private String extractIssuer(String token) {
        try {
            return RawJwtTokenParser.extractIssuer(token);
        }
        catch (Exception e) {
            throw new BadJwtException("Token is not a valid JWT or its iss claim is not parseable as String.", (Throwable)e);
        }
    }

    @Generated
    public static ReactiveIssuerJwtDecoderBuilder builder() {
        return new ReactiveIssuerJwtDecoderBuilder();
    }

    @Generated
    public static class ReactiveIssuerJwtDecoderBuilder {
        @Generated
        private ArrayList<String> issuerDecoderMap$key;
        @Generated
        private ArrayList<ReactiveJwtDecoder> issuerDecoderMap$value;

        @Generated
        ReactiveIssuerJwtDecoderBuilder() {
        }

        @Generated
        public ReactiveIssuerJwtDecoderBuilder issuerDecoder(String issuerDecoderKey, ReactiveJwtDecoder issuerDecoderValue) {
            if (this.issuerDecoderMap$key == null) {
                this.issuerDecoderMap$key = new ArrayList();
                this.issuerDecoderMap$value = new ArrayList();
            }
            this.issuerDecoderMap$key.add(issuerDecoderKey);
            this.issuerDecoderMap$value.add(issuerDecoderValue);
            return this;
        }

        @Generated
        public ReactiveIssuerJwtDecoderBuilder issuerDecoderMap(Map<? extends String, ? extends ReactiveJwtDecoder> issuerDecoderMap) {
            if (issuerDecoderMap == null) {
                throw new NullPointerException("issuerDecoderMap cannot be null");
            }
            if (this.issuerDecoderMap$key == null) {
                this.issuerDecoderMap$key = new ArrayList();
                this.issuerDecoderMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ReactiveJwtDecoder> $lombokEntry : issuerDecoderMap.entrySet()) {
                this.issuerDecoderMap$key.add($lombokEntry.getKey());
                this.issuerDecoderMap$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public ReactiveIssuerJwtDecoderBuilder clearIssuerDecoderMap() {
            if (this.issuerDecoderMap$key != null) {
                this.issuerDecoderMap$key.clear();
                this.issuerDecoderMap$value.clear();
            }
            return this;
        }

        @Generated
        public ReactiveIssuerJwtDecoder build() {
            Map<String, ReactiveJwtDecoder> issuerDecoderMap;
            switch (this.issuerDecoderMap$key == null ? 0 : this.issuerDecoderMap$key.size()) {
                case 0: {
                    issuerDecoderMap = Collections.emptyMap();
                    break;
                }
                case 1: {
                    issuerDecoderMap = Collections.singletonMap(this.issuerDecoderMap$key.get(0), this.issuerDecoderMap$value.get(0));
                    break;
                }
                default: {
                    issuerDecoderMap = new LinkedHashMap<String, ReactiveJwtDecoder>(this.issuerDecoderMap$key.size() < 0x40000000 ? 1 + this.issuerDecoderMap$key.size() + (this.issuerDecoderMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.issuerDecoderMap$key.size(); ++$i) {
                        issuerDecoderMap.put(this.issuerDecoderMap$key.get($i), this.issuerDecoderMap$value.get($i));
                    }
                    issuerDecoderMap = Collections.unmodifiableMap(issuerDecoderMap);
                }
            }
            return new ReactiveIssuerJwtDecoder(issuerDecoderMap);
        }

        @Generated
        public String toString() {
            return "ReactiveIssuerJwtDecoder.ReactiveIssuerJwtDecoderBuilder(issuerDecoderMap$key=" + String.valueOf(this.issuerDecoderMap$key) + ", issuerDecoderMap$value=" + String.valueOf(this.issuerDecoderMap$value) + ")";
        }
    }
}

