/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.client;

import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;

@AutoConfiguration
public class OAuth2ClientRegistryPostprocessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientRegistryPostprocessor.class);
    private static final String OPENID_SCOPE = "openid";

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof OAuth2ClientProperties) {
            OAuth2ClientProperties properties = (OAuth2ClientProperties)bean;
            properties.getRegistration().forEach(this::defaultToOpenidScopeForEmptyScope);
        }
        return bean;
    }

    private void defaultToOpenidScopeForEmptyScope(String registrationId, OAuth2ClientProperties.Registration registration) {
        if (registration.getScope() == null || registration.getScope().isEmpty()) {
            log.info("Client registration with id '{}' did not specify a scope. Setting scope to '{}'.", (Object)registrationId, (Object)OPENID_SCOPE);
            registration.setScope(Set.of(OPENID_SCOPE));
        } else {
            log.debug("Client registration with id '{}' requests the following scopes '{}'.", (Object)registrationId, (Object)String.join((CharSequence)", ", registration.getScope()));
        }
    }
}

