/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.configuration;

import ch.admin.bit.jeap.security.resource.semanticAuthentication.SemanticApplicationRole;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.SemanticRoleRepository;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;

public class SemanticMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    private final String systemName;

    public SemanticMethodSecurityExpressionHandler(String systemName) {
        this.systemName = systemName;
    }

    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        if (authentication instanceof JeapAuthenticationToken) {
            JeapAuthenticationToken jeapAuthenticationToken = (JeapAuthenticationToken)authentication;
            SemanticMethodSecurityExpressionRoot root = new SemanticMethodSecurityExpressionRoot(this, jeapAuthenticationToken);
            root.setThis(invocation.getThis());
            root.setPermissionEvaluator(this.getPermissionEvaluator());
            root.setTrustResolver(this.getTrustResolver());
            root.setRoleHierarchy(this.getRoleHierarchy());
            root.setDefaultRolePrefix(this.getDefaultRolePrefix());
            return root;
        }
        return super.createSecurityExpressionRoot(authentication, invocation);
    }

    public EvaluationContext createEvaluationContext(Supplier<Authentication> authentication, MethodInvocation mi) {
        StandardEvaluationContext context = (StandardEvaluationContext)super.createEvaluationContext(authentication, mi);
        Authentication authentication2 = authentication.get();
        if (authentication2 instanceof JeapAuthenticationToken) {
            JeapAuthenticationToken jeapAuthenticationToken = (JeapAuthenticationToken)authentication2;
            SemanticMethodSecurityExpressionRoot root = new SemanticMethodSecurityExpressionRoot(this, jeapAuthenticationToken);
            root.setThis(mi.getThis());
            root.setPermissionEvaluator(this.getPermissionEvaluator());
            root.setTrustResolver(this.getTrustResolver());
            root.setRoleHierarchy(this.getRoleHierarchy());
            root.setDefaultRolePrefix(this.getDefaultRolePrefix());
            context.setRootObject((Object)root);
        }
        return context;
    }

    private class SemanticMethodSecurityExpressionRoot
    extends SecurityExpressionRoot
    implements MethodSecurityExpressionOperations {
        private final SemanticRoleRepository semanticRoleRepository;
        private Object filterObject;
        private Object returnObject;
        private Object target;

        SemanticMethodSecurityExpressionRoot(SemanticMethodSecurityExpressionHandler semanticMethodSecurityExpressionHandler, JeapAuthenticationToken authentication) {
            super((Authentication)authentication);
            this.semanticRoleRepository = new SemanticRoleRepository(semanticMethodSecurityExpressionHandler.systemName, authentication);
        }

        public Object getThis() {
            return this.target;
        }

        void setThis(Object target) {
            this.target = target;
        }

        @Generated
        public Object getFilterObject() {
            return this.filterObject;
        }

        @Generated
        public void setFilterObject(Object filterObject) {
            this.filterObject = filterObject;
        }

        @Generated
        public Object getReturnObject() {
            return this.returnObject;
        }

        @Generated
        public void setReturnObject(Object returnObject) {
            this.returnObject = returnObject;
        }

        @Generated
        public boolean hasRoleForPartner(SemanticApplicationRole role, String partner) {
            return this.semanticRoleRepository.hasRoleForPartner(role, partner);
        }

        @Generated
        public boolean hasRoleForPartner(String operation, String partner) {
            return this.semanticRoleRepository.hasRoleForPartner(operation, partner);
        }

        @Generated
        public boolean hasRoleForPartner(String resource, String operation, String partner) {
            return this.semanticRoleRepository.hasRoleForPartner(resource, operation, partner);
        }

        @Generated
        public boolean hasRoleForPartner(String tenant, String resource, String operation, String partner) {
            return this.semanticRoleRepository.hasRoleForPartner(tenant, resource, operation, partner);
        }

        @Generated
        public boolean hasRole(SemanticApplicationRole role) {
            return this.semanticRoleRepository.hasRole(role);
        }

        @Generated
        public boolean hasOperation(String operation) {
            return this.semanticRoleRepository.hasOperation(operation);
        }

        @Generated
        public boolean hasRole(String resource, String operation) {
            return this.semanticRoleRepository.hasRole(resource, operation);
        }

        @Generated
        public boolean hasRole(String tenant, String resource, String operation) {
            return this.semanticRoleRepository.hasRole(tenant, resource, operation);
        }

        @Generated
        public boolean hasRoleForAllPartners(SemanticApplicationRole role) {
            return this.semanticRoleRepository.hasRoleForAllPartners(role);
        }

        @Generated
        public boolean hasRoleForAllPartners(String operation) {
            return this.semanticRoleRepository.hasRoleForAllPartners(operation);
        }

        @Generated
        public boolean hasRoleForAllPartners(String resource, String operation) {
            return this.semanticRoleRepository.hasRoleForAllPartners(resource, operation);
        }

        @Generated
        public boolean hasRoleForAllPartners(String tenant, String resource, String operation) {
            return this.semanticRoleRepository.hasRoleForAllPartners(tenant, resource, operation);
        }

        @Generated
        public Collection<SemanticApplicationRole> getAllRolesForPartner(String operation, String partner) {
            return this.semanticRoleRepository.getAllRolesForPartner(operation, partner);
        }

        @Generated
        public Collection<SemanticApplicationRole> getAllRoles(String operation) {
            return this.semanticRoleRepository.getAllRoles(operation);
        }

        @Generated
        public Collection<SemanticApplicationRole> getAllRolesForAllPartners(String operation) {
            return this.semanticRoleRepository.getAllRolesForAllPartners(operation);
        }

        @Generated
        public Collection<String> getPartnersForRole(SemanticApplicationRole role) {
            return this.semanticRoleRepository.getPartnersForRole(role);
        }

        @Generated
        public Collection<String> getPartnersForRole(String operation) {
            return this.semanticRoleRepository.getPartnersForRole(operation);
        }

        @Generated
        public Collection<String> getPartnersForRole(String resource, String operation) {
            return this.semanticRoleRepository.getPartnersForRole(resource, operation);
        }

        @Generated
        public Collection<String> getPartnersForRole(String tenant, String resource, String operation) {
            return this.semanticRoleRepository.getPartnersForRole(tenant, resource, operation);
        }

        @Generated
        public Collection<String> getPartnersForRole(Predicate<SemanticApplicationRole> rolePredicate) {
            return this.semanticRoleRepository.getPartnersForRole(rolePredicate);
        }

        @Generated
        public Map<String, Set<SemanticApplicationRole>> getBusinessPartnerRoles() {
            return this.semanticRoleRepository.getBusinessPartnerRoles();
        }

        @Generated
        public Set<SemanticApplicationRole> getUserRoles() {
            return this.semanticRoleRepository.getUserRoles();
        }

        @Generated
        public String getSystemName() {
            return this.semanticRoleRepository.getSystemName();
        }
    }
}

